/*
 * Decompiled with CFR 0.152.
 */
package name.pehl.piriti.rebind.property;

import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JConstructor;
import com.google.gwt.core.ext.typeinfo.JField;
import com.google.gwt.core.ext.typeinfo.JMethod;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import name.pehl.piriti.commons.client.NoopInstanceCreator;
import name.pehl.piriti.converter.client.Converter;
import name.pehl.piriti.converter.client.NoopConverter;
import name.pehl.piriti.property.client.NoopPropertyGetter;
import name.pehl.piriti.property.client.NoopPropertySetter;
import name.pehl.piriti.rebind.Modifier;
import name.pehl.piriti.rebind.property.DefaultConverterLookup;
import name.pehl.piriti.rebind.property.InvalidPropertyException;
import name.pehl.piriti.rebind.property.MapPropertyContext;
import name.pehl.piriti.rebind.property.PropertyAccess;
import name.pehl.piriti.rebind.property.PropertyContext;
import name.pehl.piriti.rebind.property.PropertySource;
import name.pehl.piriti.rebind.property.PropertyTemplatesLookup;
import name.pehl.piriti.rebind.property.ReferenceType;
import name.pehl.piriti.rebind.property.Templates;
import name.pehl.piriti.rebind.type.TypeContext;
import name.pehl.piriti.rebind.type.TypeUtils;
import org.apache.commons.lang.StringUtils;

public class PropertyContextCreator {
    private final TypeOracle typeOracle;
    private final DefaultConverterLookup defaultConverterLookup;
    private final PropertyTemplatesLookup propertyTemplatesLookup;

    @Inject
    public PropertyContextCreator(TypeOracle typeOracle, PropertyTemplatesLookup propertyTemplatesLookup, DefaultConverterLookup defaultConverterLookup) {
        this.typeOracle = typeOracle;
        this.propertyTemplatesLookup = propertyTemplatesLookup;
        this.defaultConverterLookup = defaultConverterLookup;
    }

    public PropertyContext createPropertyContext(TypeContext typeContext, PropertySource propertySource, ReferenceType referenceType) throws InvalidPropertyException {
        PropertyContext propertyContext;
        Map<PropertyAccess, String> access = this.calculateAccess(typeContext, propertySource);
        String keyConverter = this.getCustomConverter(typeContext, propertySource);
        String instanceCreator = this.getType(typeContext, propertySource, propertySource.getInstanceCreator(), NoopInstanceCreator.class);
        String getter = this.getType(typeContext, propertySource, propertySource.getGetter(), NoopPropertyGetter.class);
        String setter = this.getType(typeContext, propertySource, propertySource.getSetter(), NoopPropertySetter.class);
        Templates templates = this.propertyTemplatesLookup.get(typeContext, propertySource.getType(), referenceType);
        if (keyConverter == null) {
            keyConverter = this.defaultConverterLookup.get(propertySource.getType());
        }
        if (TypeUtils.isMap(propertySource.getType())) {
            MapPropertyContext mapPropertyContext = new MapPropertyContext(this.typeOracle, propertySource, access, referenceType);
            String valueConverter = this.defaultConverterLookup.get(mapPropertyContext.getValueType());
            mapPropertyContext.setValueConverter(valueConverter);
            propertyContext = mapPropertyContext;
        } else {
            propertyContext = new PropertyContext(this.typeOracle, propertySource, access, referenceType);
        }
        propertyContext.setConverter(keyConverter);
        propertyContext.setInstanceCreator(instanceCreator);
        propertyContext.setGetter(getter);
        propertyContext.setSetter(setter);
        propertyContext.setTemplates(templates);
        return propertyContext;
    }

    private Map<PropertyAccess, String> calculateAccess(TypeContext typeContext, PropertySource propertySource) {
        HashMap<PropertyAccess, String> access = new HashMap<PropertyAccess, String>();
        JField field = TypeUtils.findField(typeContext.getType(), propertySource.getName(), new Modifier[0]);
        if (field != null) {
            boolean samePackage;
            JClassType enclosingType = field.getEnclosingType();
            boolean bl = samePackage = typeContext.getRwType().getPackage() == enclosingType.getPackage();
            if (!field.isFinal() && (field.isPublic() || samePackage && (field.isDefaultAccess() || field.isProtected()))) {
                access.put(PropertyAccess.FIELD, field.getName());
            }
            JMethod getter = null;
            getter = samePackage ? TypeUtils.findGetter(typeContext.getType(), propertySource.getName(), propertySource.getType(), Modifier.DEFAULT, Modifier.PROTECTED, Modifier.PUBLIC) : TypeUtils.findGetter(typeContext.getType(), propertySource.getName(), propertySource.getType(), Modifier.PUBLIC);
            if (getter != null) {
                access.put(PropertyAccess.GETTER, getter.getName());
            }
            JMethod setter = null;
            setter = samePackage ? TypeUtils.findSetter(typeContext.getType(), propertySource.getName(), propertySource.getType(), Modifier.DEFAULT, Modifier.PROTECTED, Modifier.PUBLIC) : TypeUtils.findSetter(typeContext.getType(), propertySource.getName(), propertySource.getType(), Modifier.PUBLIC);
            if (setter != null) {
                access.put(PropertyAccess.SETTER, setter.getName());
            }
        }
        return access;
    }

    private String getCustomConverter(TypeContext typeContext, PropertySource propertySource) throws InvalidPropertyException {
        JClassType converterType = null;
        String format = propertySource.getFormat();
        Class<Converter<?>> converterClass = propertySource.getConverter();
        if (converterClass != null && converterClass != NoopConverter.class) {
            converterType = this.typeOracle.findType(converterClass.getName());
            if (converterType == null) {
                throw new InvalidPropertyException(typeContext, propertySource.getType(), propertySource.getName(), "Converter " + converterClass.getName() + " cannot be found");
            }
            if (StringUtils.isEmpty((String)format)) {
                if (!TypeUtils.isDefaultInstantiable((JType)converterType)) {
                    throw new InvalidPropertyException(typeContext, propertySource.getType(), propertySource.getName(), "Converter " + converterClass.getName() + " has no default constructor");
                }
            } else {
                JClassType stringType = this.typeOracle.findType(String.class.getName());
                JConstructor constructor = converterType.findConstructor(new JType[]{stringType});
                if (constructor == null) {
                    throw new InvalidPropertyException(typeContext, propertySource.getType(), propertySource.getName(), "Converter " + converterClass.getName() + " has no constructor which accepts the format \"" + format + "\"");
                }
            }
        }
        if (converterType != null) {
            return converterType.getQualifiedSourceName();
        }
        return null;
    }

    private String getType(TypeContext typeContext, PropertySource propertySource, Class<?> clazz, Class<?> defaultValue) throws InvalidPropertyException {
        JClassType type = null;
        if (clazz != null && clazz != defaultValue) {
            type = this.typeOracle.findType(clazz.getName());
            if (type == null) {
                throw new InvalidPropertyException(typeContext, propertySource.getType(), propertySource.getName(), clazz.getName() + " cannot be found");
            }
            if (!TypeUtils.isDefaultInstantiable((JType)type)) {
                throw new InvalidPropertyException(typeContext, propertySource.getType(), propertySource.getName(), clazz.getName() + " has no default constructor");
            }
        }
        if (type != null) {
            return type.getQualifiedSourceName();
        }
        return null;
    }
}

