/*
 * Decompiled with CFR 0.152.
 */
package name.pehl.piriti.rebind.property;

import com.google.gwt.core.ext.typeinfo.JArrayType;
import com.google.gwt.core.ext.typeinfo.JType;
import java.util.Map;
import name.pehl.piriti.rebind.property.InvalidPropertyException;
import name.pehl.piriti.rebind.property.PropertyAccess;
import name.pehl.piriti.rebind.property.PropertyContext;
import name.pehl.piriti.rebind.property.ReferenceType;
import name.pehl.piriti.rebind.property.Templates;
import name.pehl.piriti.rebind.type.TypeContext;
import name.pehl.piriti.rebind.type.TypeUtils;
import org.apache.commons.lang.StringUtils;

public class PropertyContextValidator {
    public void validate(TypeContext typeContext, PropertyContext propertyContext) throws InvalidPropertyException {
        this.validateType(typeContext, propertyContext);
        this.validatePath(typeContext, propertyContext);
        this.validateAccess(typeContext, propertyContext);
        this.validateMandatoryConverters(typeContext, propertyContext);
        this.validateTemplates(typeContext, propertyContext);
    }

    private void validateType(TypeContext typeContext, PropertyContext propertyContext) throws InvalidPropertyException {
        JType elementType;
        JType propertyType = propertyContext.getType();
        JArrayType arrayType = propertyType.isArray();
        if (arrayType != null) {
            elementType = arrayType.getComponentType();
            if (elementType.isArray() != null) {
                throw new InvalidPropertyException(typeContext, propertyContext.getType(), propertyContext.getName(), "Multi-dimensional arrays are not supported");
            }
            if (TypeUtils.isCollection(elementType) || TypeUtils.isMap(elementType)) {
                throw new InvalidPropertyException(typeContext, propertyContext.getType(), propertyContext.getName(), "Arrays of collections / maps are not supported");
            }
        }
        if (TypeUtils.isCollection(propertyType)) {
            elementType = TypeUtils.getTypeVariable(propertyType);
            if (elementType == null) {
                throw new InvalidPropertyException(typeContext, propertyContext.getType(), propertyContext.getName(), "No type parameter found");
            }
            if (elementType.isArray() != null) {
                throw new InvalidPropertyException(typeContext, propertyContext.getType(), propertyContext.getName(), "Collections of arrays are not supported");
            }
            if (TypeUtils.isCollection(elementType) || TypeUtils.isMap(elementType)) {
                throw new InvalidPropertyException(typeContext, propertyContext.getType(), propertyContext.getName(), "Collections of collections / maps are not supported");
            }
        }
        if (propertyContext.getReferenceType() == ReferenceType.ID || propertyContext.getReferenceType() == ReferenceType.REFERENCE) {
            // empty if block
        }
    }

    private void validatePath(TypeContext typeContext, PropertyContext propertyContext) throws InvalidPropertyException {
        String path;
        if (typeContext.isWriter() && (path = propertyContext.getPath()) != null) {
            JType type = propertyContext.getType();
            if (typeContext.isJson() && propertyContext.isJsonPath()) {
                throw new InvalidPropertyException(typeContext, type, propertyContext.getName(), "The JSONPath " + path + " is not supported for writing");
            }
            if (typeContext.isXml() && propertyContext.isXpath()) {
                if (StringUtils.containsAny((String)path, (char[])new char[]{'.', '[', ']', '(', ')'})) {
                    throw new InvalidPropertyException(typeContext, type, propertyContext.getName(), "The XPath " + path + " is not supported for writing");
                }
                if (path.contains("@")) {
                    if (type.isArray() != null || TypeUtils.isCollection(type)) {
                        throw new InvalidPropertyException(typeContext, type, propertyContext.getName(), "The XPath " + path + " is not supported when writing arrays/collections");
                    }
                    String[] parts = path.split("@");
                    if (parts.length != 2) {
                        throw new InvalidPropertyException(typeContext, type, propertyContext.getName(), "The XPath " + path + " is not supported for writing");
                    }
                    if (parts[1].contains("/")) {
                        throw new InvalidPropertyException(typeContext, type, propertyContext.getName(), "The XPath " + path + " is not supported for writing");
                    }
                }
            }
        }
    }

    private void validateAccess(TypeContext typeContext, PropertyContext propertyContext) throws InvalidPropertyException {
        Map<PropertyAccess, String> access = propertyContext.getAccess();
        if (typeContext.isReader()) {
            if (!access.containsKey((Object)PropertyAccess.FIELD) && !access.containsKey((Object)PropertyAccess.SETTER) && propertyContext.getSetter() == null) {
                throw new InvalidPropertyException(typeContext, propertyContext.getType(), propertyContext.getName(), "No accessible field or setter and no custom setter specified");
            }
        } else if (typeContext.isWriter() && !access.containsKey((Object)PropertyAccess.FIELD) && !access.containsKey((Object)PropertyAccess.GETTER) && propertyContext.getGetter() == null) {
            throw new InvalidPropertyException(typeContext, propertyContext.getType(), propertyContext.getName(), "No accessible field or getter and no custom getter specified");
        }
    }

    private void validateMandatoryConverters(TypeContext typeContext, PropertyContext propertyContext) throws InvalidPropertyException {
        JType type;
        String converter = propertyContext.getConverter();
        if (converter == null && (TypeUtils.isBoolean(type = propertyContext.getType()) || TypeUtils.isCharacter(type) || TypeUtils.isDate(type) || TypeUtils.isNumeric(type) || Object.class.getName().equals(type.getQualifiedSourceName()))) {
            throw new InvalidPropertyException(typeContext, propertyContext.getType(), propertyContext.getName(), "No converter for " + type.getQualifiedSourceName() + " specified");
        }
    }

    private void validateTemplates(TypeContext typeContext, PropertyContext propertyContext) throws InvalidPropertyException {
        Templates templates = propertyContext.getTemplates();
        if (templates == null || templates == Templates.NO_TEMPLATES) {
            throw new InvalidPropertyException(typeContext, propertyContext.getType(), propertyContext.getName(), "No templates found");
        }
    }
}

