/*
 * Decompiled with CFR 0.152.
 */
package name.pehl.piriti.rebind.property;

import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JParameterizedType;
import com.google.gwt.core.ext.typeinfo.JType;
import name.pehl.piriti.rebind.property.ReferenceType;
import name.pehl.piriti.rebind.property.Templates;
import name.pehl.piriti.rebind.type.TypeContext;
import name.pehl.piriti.rebind.type.TypeUtils;

public class PropertyTemplatesLookup {
    public Templates get(TypeContext typeContext, JType type, ReferenceType referenceType) {
        Templates templates = Templates.NO_TEMPLATES;
        String path = this.getPath(typeContext, referenceType);
        String template = this.getTemplate(type, referenceType);
        String elementTypeTemplate = null;
        String valueTypeTemplate = null;
        if (referenceType == ReferenceType.PROPERTY && (type.isArray() != null || TypeUtils.isCollection(type) || TypeUtils.isMap(type))) {
            JType elementType = null;
            JClassType valueType = null;
            if (type.isArray() != null) {
                elementType = type.isArray().getComponentType();
            } else if (TypeUtils.isCollection(type)) {
                elementType = TypeUtils.getTypeVariable(type);
            } else {
                elementType = ((JParameterizedType)type).getTypeArgs()[0];
                valueType = ((JParameterizedType)type).getTypeArgs()[1];
            }
            if (elementType != null) {
                elementTypeTemplate = this.getTemplate(elementType, referenceType);
            }
            if (valueType != null) {
                valueTypeTemplate = this.getTemplate((JType)valueType, referenceType);
            }
        }
        if (template != null) {
            String fullQualifiedTemplatePath = path + "/" + template;
            String fullQualifiedElementTypeTemplatePath = null;
            String fullQualifiedValueTypeTemplatePath = null;
            if (elementTypeTemplate != null) {
                fullQualifiedElementTypeTemplatePath = path + "/elementtype/" + elementTypeTemplate;
            }
            if (valueTypeTemplate != null) {
                fullQualifiedValueTypeTemplatePath = path + "/elementtype/" + valueTypeTemplate;
            }
            templates = new Templates(fullQualifiedTemplatePath, fullQualifiedElementTypeTemplatePath, fullQualifiedValueTypeTemplatePath);
        }
        return templates;
    }

    private String getPath(TypeContext typeContext, ReferenceType referenceType) {
        StringBuilder path = new StringBuilder("name/pehl/piriti/rebind/");
        String jsonxml = typeContext.isJson() ? "json" : "xml";
        String rw = typeContext.isReader() ? "reader" : "writer";
        path.append(jsonxml).append("/").append(rw).append("/").append(referenceType.name().toLowerCase());
        return path.toString();
    }

    private String getTemplate(JType type, ReferenceType referenceType) {
        String template = null;
        switch (referenceType) {
            case ID: {
                template = "string.vm";
                break;
            }
            case PROPERTY: {
                if (TypeUtils.isBoolean(type)) {
                    template = "boolean.vm";
                    break;
                }
                if (TypeUtils.isNumeric(type)) {
                    template = "numeric.vm";
                    break;
                }
                if (TypeUtils.isCharacter(type)) {
                    template = "character.vm";
                    break;
                }
                if (TypeUtils.isString(type)) {
                    template = "string.vm";
                    break;
                }
                if (type.isEnum() != null) {
                    template = "enum.vm";
                    break;
                }
                if (TypeUtils.isDate(type)) {
                    template = "date.vm";
                    break;
                }
                if (type.isArray() != null) {
                    template = "array.vm";
                    break;
                }
                if (TypeUtils.isCollection(type)) {
                    template = "collection.vm";
                    break;
                }
                if (TypeUtils.isMap(type)) {
                    template = "map.vm";
                    break;
                }
                template = "any.vm";
                break;
            }
            case REFERENCE: {
                if (type.isArray() != null) {
                    template = "array.vm";
                    break;
                }
                if (TypeUtils.isCollection(type)) {
                    template = "collection.vm";
                    break;
                }
                if (!TypeUtils.canContainId(type)) break;
                template = "any.vm";
            }
        }
        return template;
    }
}

