/*
 * Decompiled with CFR 0.152.
 */
package name.pehl.piriti.rebind.type;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import java.util.HashSet;
import java.util.Set;
import name.pehl.piriti.rebind.Logger;
import name.pehl.piriti.rebind.property.InvalidPropertyException;
import name.pehl.piriti.rebind.property.PropertyContext;
import name.pehl.piriti.rebind.property.PropertyContextCreator;
import name.pehl.piriti.rebind.property.PropertyContextValidator;
import name.pehl.piriti.rebind.property.PropertySource;
import name.pehl.piriti.rebind.property.ReferenceType;
import name.pehl.piriti.rebind.type.TypeContext;
import name.pehl.piriti.rebind.type.TypeProcessor;

public abstract class AbstractTypeProcessor
implements TypeProcessor {
    private TypeProcessor next;
    private Set<? extends JClassType> skipTypes = new HashSet<JClassType>();
    protected final PropertyContextCreator propertyContextCreator;
    protected final PropertyContextValidator propertyContextValidator;
    protected final Logger logger;

    public AbstractTypeProcessor(PropertyContextCreator propertyContextCreator, PropertyContextValidator propertyContextValidator, Logger logger) {
        this.propertyContextCreator = propertyContextCreator;
        this.propertyContextValidator = propertyContextValidator;
        this.logger = logger;
    }

    @Override
    public TypeProcessor getNext() {
        return this.next;
    }

    @Override
    public void setNext(TypeProcessor processor) {
        this.next = processor;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public final void process(TypeContext typeContext) throws UnableToCompleteException {
        this.logger.debug("Entering TypeProcessor %s - processing %s", this.getClass().getSimpleName(), typeContext);
        this.skipTypes = typeContext.getStopAt().getFlattenedSupertypeHierarchy();
        this.doProcess(typeContext, this.skipTypes);
        if (this.hasNext()) {
            this.getNext().process(typeContext);
        }
    }

    protected abstract void doProcess(TypeContext var1, Set<? extends JClassType> var2) throws UnableToCompleteException;

    protected boolean skipType(JClassType type) {
        if (type == null) {
            return true;
        }
        for (JClassType jClassType : this.skipTypes) {
            if (jClassType.isInterface() != null || !jClassType.equals(type)) continue;
            return true;
        }
        return false;
    }

    protected void addProperty(TypeContext typeContext, PropertySource propertySource) {
        try {
            PropertyContext propertyContext = this.createPropertyContext(typeContext, propertySource, ReferenceType.PROPERTY);
            this.logger.debug("Adding property %s to %s", propertyContext, typeContext);
            typeContext.addProperty(propertyContext);
        }
        catch (InvalidPropertyException e) {
            typeContext.removeProperty(propertySource.getName());
            this.invalidProperty(typeContext, propertySource, e);
        }
    }

    protected void setId(TypeContext typeContext, PropertySource propertySource) {
        try {
            PropertyContext propertyContext = this.createPropertyContext(typeContext, propertySource, ReferenceType.ID);
            this.logger.debug("Setting id %s for %s", propertyContext, typeContext);
            typeContext.setId(propertyContext);
        }
        catch (InvalidPropertyException e) {
            typeContext.setId(null);
            this.invalidProperty(typeContext, propertySource, e);
        }
    }

    protected void addReference(TypeContext typeContext, PropertySource propertySource) {
        try {
            PropertyContext propertyContext = this.createPropertyContext(typeContext, propertySource, ReferenceType.REFERENCE);
            this.logger.debug("Adding reference %s to %s", propertyContext, typeContext);
            typeContext.addReference(propertyContext);
        }
        catch (InvalidPropertyException e) {
            typeContext.removeReference(propertySource.getName());
            this.invalidProperty(typeContext, propertySource, e);
        }
    }

    private PropertyContext createPropertyContext(TypeContext typeContext, PropertySource propertySource, ReferenceType referenceType) throws InvalidPropertyException {
        PropertyContext propertyContext = this.propertyContextCreator.createPropertyContext(typeContext, propertySource, referenceType);
        this.propertyContextValidator.validate(typeContext, propertyContext);
        return propertyContext;
    }

    private void invalidProperty(TypeContext typeContext, PropertySource propertySource, InvalidPropertyException e) {
        this.logger.warn(e.getMessage(), new Object[0]);
    }
}

