/*
 * Decompiled with CFR 0.152.
 */
package name.pehl.piriti.rebind.type;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JField;
import com.google.gwt.core.ext.typeinfo.JType;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import name.pehl.piriti.commons.client.CreateWith;
import name.pehl.piriti.commons.client.Format;
import name.pehl.piriti.commons.client.Id;
import name.pehl.piriti.commons.client.IdRef;
import name.pehl.piriti.commons.client.InstanceCreator;
import name.pehl.piriti.commons.client.Native;
import name.pehl.piriti.commons.client.Order;
import name.pehl.piriti.commons.client.Path;
import name.pehl.piriti.commons.client.Transient;
import name.pehl.piriti.commons.client.Whitespace;
import name.pehl.piriti.converter.client.Convert;
import name.pehl.piriti.converter.client.Converter;
import name.pehl.piriti.property.client.Getter;
import name.pehl.piriti.property.client.PropertyGetter;
import name.pehl.piriti.property.client.PropertySetter;
import name.pehl.piriti.property.client.Setter;
import name.pehl.piriti.rebind.Logger;
import name.pehl.piriti.rebind.property.PropertyContextCreator;
import name.pehl.piriti.rebind.property.PropertyContextValidator;
import name.pehl.piriti.rebind.property.PropertySource;
import name.pehl.piriti.rebind.type.AbstractTypeProcessor;
import name.pehl.piriti.rebind.type.TypeContext;
import name.pehl.totoe.commons.client.WhitespaceHandling;

public class PojoTypeProcessor
extends AbstractTypeProcessor {
    @Inject
    public PojoTypeProcessor(PropertyContextCreator propertyContextCreator, PropertyContextValidator propertyContextValidator, Logger logger) {
        super(propertyContextCreator, propertyContextValidator, logger);
    }

    @Override
    protected void doProcess(TypeContext typeContext, Set<? extends JClassType> skipTypes) throws UnableToCompleteException {
        this.logger.debug("Collect normal mappings...", new Object[0]);
        ArrayList<JField> fields = new ArrayList<JField>();
        this.collectFields(typeContext.getType(), fields, Collections.emptySet(), new HashSet<Class<? extends Annotation>>(Arrays.asList(Transient.class, Id.class, IdRef.class)));
        for (JField field : fields) {
            this.addProperty(typeContext, new FieldPropertySource(field));
        }
        this.logger.debug("Normal mappings done", new Object[0]);
        this.logger.debug("Looking for id...", new Object[0]);
        ArrayList<JField> idFields = new ArrayList<JField>();
        this.collectFields(typeContext.getType(), idFields, new HashSet<Class<? extends Annotation>>(Arrays.asList(Id.class)), new HashSet<Class<? extends Annotation>>(Arrays.asList(Transient.class, IdRef.class)));
        if (!idFields.isEmpty()) {
            if (idFields.size() > 1) {
                this.logger.die("%s id mappings defined in the type hirarchy of %s. Only one id mapping is allowed!", idFields.size(), typeContext.getType().getParameterizedQualifiedSourceName());
            } else {
                this.setId(typeContext, new FieldPropertySource((JField)idFields.get(0)));
            }
        }
        this.logger.debug("Id done", new Object[0]);
        this.logger.debug("Collect reference mappings...", new Object[0]);
        ArrayList<JField> refFields = new ArrayList<JField>();
        this.collectFields(typeContext.getType(), refFields, new HashSet<Class<? extends Annotation>>(Arrays.asList(IdRef.class)), new HashSet<Class<? extends Annotation>>(Arrays.asList(Transient.class, Id.class)));
        for (JField refField : refFields) {
            this.addReference(typeContext, new FieldPropertySource(refField));
        }
        this.logger.debug("Reference mappings done", new Object[0]);
    }

    protected void collectFields(JClassType type, List<JField> fields, Set<Class<? extends Annotation>> mustHaveAnnotations, Set<Class<? extends Annotation>> annotationsToSkip) {
        if (this.skipType(type)) {
            return;
        }
        this.collectFields(type.getSuperclass(), fields, mustHaveAnnotations, annotationsToSkip);
        JField[] currentFields = type.getFields();
        if (currentFields != null) {
            for (JField field : currentFields) {
                if (this.skipField(field, annotationsToSkip) || !this.includeField(field, mustHaveAnnotations)) continue;
                fields.add(field);
            }
        }
    }

    protected boolean skipField(JField field, Set<Class<? extends Annotation>> annotationsToSkip) {
        if (field.isTransient() || field.isStatic()) {
            this.logger.debug("Skipping %s field %s in %s", field.isTransient() ? "transient" : "static", field.getName(), field.getEnclosingType().getParameterizedQualifiedSourceName());
            return true;
        }
        for (Class<? extends Annotation> a : annotationsToSkip) {
            if (!field.isAnnotationPresent(a)) continue;
            this.logger.debug("Skipping field %s in %s as it is annotated with @%s", field.getName(), field.getEnclosingType().getParameterizedQualifiedSourceName(), a.getClass().getName());
            return true;
        }
        return false;
    }

    private boolean includeField(JField field, Set<Class<? extends Annotation>> mustHaveAnnotations) {
        if (mustHaveAnnotations.isEmpty()) {
            return true;
        }
        for (Class<? extends Annotation> a : mustHaveAnnotations) {
            if (!field.isAnnotationPresent(a)) continue;
            return true;
        }
        this.logger.debug("Skipping field %s in %s as it is not annotated with any of %s", field.getName(), field.getEnclosingType().getParameterizedQualifiedSourceName(), mustHaveAnnotations);
        return false;
    }

    static class FieldPropertySource
    implements PropertySource {
        final JField field;

        FieldPropertySource(JField field) {
            this.field = field;
        }

        @Override
        public int getOrder() {
            int order = TypeContext.nextOrder();
            if (this.field.isAnnotationPresent(Order.class)) {
                order = ((Order)this.field.getAnnotation(Order.class)).value();
            }
            return order;
        }

        @Override
        public JType getType() {
            return this.field.getType();
        }

        @Override
        public String getName() {
            return this.field.getName();
        }

        @Override
        public String getPath() {
            String path = null;
            if (this.field.isAnnotationPresent(Id.class)) {
                path = ((Id)this.field.getAnnotation(Id.class)).value();
            } else if (this.field.isAnnotationPresent(IdRef.class)) {
                path = ((IdRef)this.field.getAnnotation(IdRef.class)).value();
            } else if (this.field.isAnnotationPresent(Path.class)) {
                path = ((Path)this.field.getAnnotation(Path.class)).value();
            }
            return path;
        }

        @Override
        public Class<? extends Converter<?>> getConverter() {
            Class converter = null;
            if (this.field.isAnnotationPresent(Convert.class)) {
                converter = ((Convert)this.field.getAnnotation(Convert.class)).value();
            }
            return converter;
        }

        @Override
        public String getFormat() {
            String format = null;
            if (this.field.isAnnotationPresent(Format.class)) {
                format = ((Format)this.field.getAnnotation(Format.class)).value();
            }
            return format;
        }

        @Override
        public WhitespaceHandling getWhitespaceHandling() {
            WhitespaceHandling whitespaceHandling = WhitespaceHandling.REMOVE;
            if (this.field.isAnnotationPresent(Whitespace.class)) {
                whitespaceHandling = ((Whitespace)this.field.getAnnotation(Whitespace.class)).value();
            }
            return whitespaceHandling;
        }

        @Override
        public boolean isNative() {
            boolean nativ = this.field.isAnnotationPresent(Native.class);
            return nativ;
        }

        @Override
        public Class<? extends InstanceCreator<?, ?>> getInstanceCreator() {
            Class instanceCreator = null;
            if (this.field.isAnnotationPresent(CreateWith.class)) {
                instanceCreator = ((CreateWith)this.field.getAnnotation(CreateWith.class)).value();
            }
            return instanceCreator;
        }

        @Override
        public Class<? extends PropertyGetter<?, ?>> getGetter() {
            Class getter = null;
            if (this.field.isAnnotationPresent(Getter.class)) {
                getter = ((Getter)this.field.getAnnotation(Getter.class)).value();
            }
            return getter;
        }

        @Override
        public Class<? extends PropertySetter<?, ?>> getSetter() {
            Class setter = null;
            if (this.field.isAnnotationPresent(Setter.class)) {
                setter = ((Setter)this.field.getAnnotation(Setter.class)).value();
            }
            return setter;
        }
    }
}

