/*
 * Decompiled with CFR 0.152.
 */
package name.pehl.piriti.rebind.type;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JField;
import com.google.gwt.core.ext.typeinfo.JType;
import java.util.Set;
import javax.inject.Inject;
import name.pehl.piriti.commons.client.InstanceCreator;
import name.pehl.piriti.commons.client.Mapping;
import name.pehl.piriti.commons.client.Mappings;
import name.pehl.piriti.converter.client.Converter;
import name.pehl.piriti.property.client.PropertyGetter;
import name.pehl.piriti.property.client.PropertySetter;
import name.pehl.piriti.rebind.Logger;
import name.pehl.piriti.rebind.Modifier;
import name.pehl.piriti.rebind.property.PropertyContextCreator;
import name.pehl.piriti.rebind.property.PropertyContextValidator;
import name.pehl.piriti.rebind.property.PropertySource;
import name.pehl.piriti.rebind.type.AbstractTypeProcessor;
import name.pehl.piriti.rebind.type.TypeContext;
import name.pehl.piriti.rebind.type.TypeUtils;
import name.pehl.totoe.commons.client.WhitespaceHandling;

public class RwTypeProcessor
extends AbstractTypeProcessor {
    @Inject
    public RwTypeProcessor(PropertyContextCreator propertyContextCreator, PropertyContextValidator propertyContextValidator, Logger logger) {
        super(propertyContextCreator, propertyContextValidator, logger);
    }

    @Override
    protected void doProcess(TypeContext typeContext, Set<? extends JClassType> skipTypes) throws UnableToCompleteException {
        JClassType rwType = typeContext.getRwType();
        if (rwType.isAnnotationPresent(Mappings.class)) {
            Mapping[] refMappings;
            Mapping[] mappings;
            this.logger.debug("Collect normal mappings...", new Object[0]);
            Mappings mappingsAnno = (Mappings)rwType.getAnnotation(Mappings.class);
            for (Mapping mapping : mappings = mappingsAnno.value()) {
                this.addProperty(typeContext, new AnnotationPropertySource(typeContext, mapping, this.logger));
            }
            this.logger.debug("Normal mappings done", new Object[0]);
            this.logger.debug("Looking for id...", new Object[0]);
            Mapping idMapping = mappingsAnno.id();
            if (!idMapping.value().equals("This is a special no-id-marker. Do not use for real IDs!")) {
                this.setId(typeContext, new AnnotationPropertySource(typeContext, idMapping, this.logger));
            }
            this.logger.debug("Id done", new Object[0]);
            this.logger.debug("Collect reference mappings...", new Object[0]);
            for (Mapping refMapping : refMappings = mappingsAnno.references()) {
                this.addReference(typeContext, new AnnotationPropertySource(typeContext, refMapping, this.logger));
            }
            this.logger.debug("Reference mappings done", new Object[0]);
        }
    }

    static class AnnotationPropertySource
    implements PropertySource {
        final Mapping mapping;
        final JField field;
        final Logger logger;

        AnnotationPropertySource(TypeContext typeContext, Mapping mapping, Logger logger) throws UnableToCompleteException {
            this.mapping = mapping;
            this.field = TypeUtils.findField(typeContext.getType(), mapping.value(), new Modifier[0]);
            this.logger = logger;
            if (this.field == null) {
                logger.die("Cannot find field %s in type %s", mapping.value(), typeContext.getType());
            }
        }

        @Override
        public int getOrder() {
            return TypeContext.nextOrder();
        }

        @Override
        public JType getType() {
            return this.field.getType();
        }

        @Override
        public String getName() {
            return this.field.getName();
        }

        @Override
        public String getPath() {
            return this.mapping.path();
        }

        @Override
        public Class<? extends Converter<?>> getConverter() {
            return this.mapping.convert();
        }

        @Override
        public String getFormat() {
            return this.mapping.format();
        }

        @Override
        public WhitespaceHandling getWhitespaceHandling() {
            return this.mapping.whitespace();
        }

        @Override
        public boolean isNative() {
            return this.mapping.native_();
        }

        @Override
        public Class<? extends InstanceCreator<?, ?>> getInstanceCreator() {
            return this.mapping.createWith();
        }

        @Override
        public Class<? extends PropertyGetter<?, ?>> getGetter() {
            return this.mapping.getter();
        }

        @Override
        public Class<? extends PropertySetter<?, ?>> getSetter() {
            return this.mapping.setter();
        }
    }
}

