/*
 * Decompiled with CFR 0.152.
 */
package name.pehl.piriti.rebind.type;

import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import name.pehl.piriti.commons.client.CreateWith;
import name.pehl.piriti.commons.client.MapUpTo;
import name.pehl.piriti.json.client.JsonReader;
import name.pehl.piriti.json.client.JsonWriter;
import name.pehl.piriti.rebind.property.PropertyContext;
import name.pehl.piriti.xml.client.XmlReader;
import name.pehl.piriti.xml.client.XmlWriter;

public class TypeContext {
    private static int internalOrder = 0x3FFFFFFF;
    private final JClassType type;
    private final JClassType rwType;
    private JClassType instanceCreator;
    private JClassType stopAt;
    private PropertyContext id;
    private final Map<String, PropertyContext> properties;
    private final Map<String, PropertyContext> references;

    public TypeContext(TypeOracle typeOracle, JClassType type, JClassType rwType) {
        Class clazz;
        this.type = type;
        this.rwType = rwType;
        this.references = new HashMap<String, PropertyContext>();
        this.properties = new HashMap<String, PropertyContext>();
        this.instanceCreator = null;
        if (this.type.isAnnotationPresent(CreateWith.class)) {
            clazz = ((CreateWith)this.type.getAnnotation(CreateWith.class)).value();
            this.instanceCreator = typeOracle.findType(clazz.getName());
        }
        if (this.rwType.isAnnotationPresent(CreateWith.class)) {
            clazz = ((CreateWith)this.rwType.getAnnotation(CreateWith.class)).value();
            this.instanceCreator = typeOracle.findType(clazz.getName());
        }
        this.stopAt = null;
        if (this.type.isAnnotationPresent(MapUpTo.class)) {
            this.stopAt = typeOracle.findType(((MapUpTo)this.type.getAnnotation(MapUpTo.class)).value().getName()).getSuperclass();
        }
        if (this.rwType.isAnnotationPresent(MapUpTo.class)) {
            this.stopAt = typeOracle.findType(((MapUpTo)this.rwType.getAnnotation(MapUpTo.class)).value().getName()).getSuperclass();
        }
        if (this.stopAt == null) {
            this.stopAt = typeOracle.findType(Object.class.getName());
        }
        if (this.stopAt == null) {
            throw new AssertionError((Object)"Type info for java.lang.Object not found!");
        }
    }

    public static int nextOrder() {
        return internalOrder++;
    }

    public String toString() {
        return "TypeContext [" + this.rwType.getParameterizedQualifiedSourceName() + " for " + this.type.getParameterizedQualifiedSourceName() + "]";
    }

    public boolean isJson() {
        Set hierarchy = this.rwType.getFlattenedSupertypeHierarchy();
        for (JClassType type : hierarchy) {
            if (!JsonReader.class.getName().equals(type.getQualifiedSourceName()) && !JsonWriter.class.getName().equals(type.getQualifiedSourceName())) continue;
            return true;
        }
        return false;
    }

    public boolean isXml() {
        Set hierarchy = this.rwType.getFlattenedSupertypeHierarchy();
        for (JClassType type : hierarchy) {
            if (!XmlReader.class.getName().equals(type.getQualifiedSourceName()) && !XmlWriter.class.getName().equals(type.getQualifiedSourceName())) continue;
            return true;
        }
        return false;
    }

    public void addProperty(PropertyContext propertyContext) {
        this.properties.put(propertyContext.getName(), propertyContext);
    }

    public PropertyContext removeProperty(String property) {
        if (property != null) {
            return this.properties.remove(property);
        }
        return null;
    }

    public void addReference(PropertyContext propertyContext) {
        this.references.put(propertyContext.getName(), propertyContext);
        this.removeProperty(propertyContext.getName());
    }

    public PropertyContext removeReference(String property) {
        if (property != null) {
            return this.references.remove(property);
        }
        return null;
    }

    public JClassType getType() {
        return this.type;
    }

    public JClassType getRwType() {
        return this.rwType;
    }

    public boolean isReader() {
        boolean reader = false;
        Set hierarchy = this.rwType.getFlattenedSupertypeHierarchy();
        if (hierarchy != null) {
            for (JClassType h : hierarchy) {
                if (!h.getQualifiedSourceName().equals(JsonReader.class.getName()) && !h.getQualifiedSourceName().equals(XmlReader.class.getName())) continue;
                return true;
            }
        }
        return reader;
    }

    public boolean isWriter() {
        boolean writer = false;
        Set hierarchy = this.rwType.getFlattenedSupertypeHierarchy();
        if (hierarchy != null) {
            for (JClassType h : hierarchy) {
                if (!h.getQualifiedSourceName().equals(JsonWriter.class.getName()) && !h.getQualifiedSourceName().equals(XmlWriter.class.getName())) continue;
                return true;
            }
        }
        return writer;
    }

    public JClassType getInstanceCreator() {
        return this.instanceCreator;
    }

    public JClassType getStopAt() {
        return this.stopAt;
    }

    public PropertyContext getId() {
        return this.id;
    }

    public void setId(PropertyContext propertyContext) {
        this.id = propertyContext;
        if (propertyContext != null) {
            this.removeProperty(propertyContext.getName());
        }
    }

    public List<PropertyContext> getProperties() {
        ArrayList<PropertyContext> ordered = new ArrayList<PropertyContext>(this.properties.values());
        Collections.sort(ordered, new PropertyContext.PropertyContextOrder());
        return ordered;
    }

    public List<PropertyContext> getReferences() {
        ArrayList<PropertyContext> ordered = new ArrayList<PropertyContext>(this.references.values());
        Collections.sort(ordered, new PropertyContext.PropertyContextOrder());
        return ordered;
    }
}

