/*
 * Decompiled with CFR 0.152.
 */
package name.pehl.piriti.rebind.type;

import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JField;
import com.google.gwt.core.ext.typeinfo.JGenericType;
import com.google.gwt.core.ext.typeinfo.JMethod;
import com.google.gwt.core.ext.typeinfo.JParameterizedType;
import com.google.gwt.core.ext.typeinfo.JPrimitiveType;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import name.pehl.piriti.rebind.Modifier;

public final class TypeUtils {
    protected static Map<String, String> interfaceToImplementation = new HashMap<String, String>();

    private TypeUtils() {
    }

    public static boolean isBoolean(JType type) {
        if (type != null) {
            JPrimitiveType primitive = type.isPrimitive();
            return primitive != null && primitive.equals((Object)JPrimitiveType.BOOLEAN) || type.getQualifiedSourceName().equals(Boolean.class.getName());
        }
        return false;
    }

    public static boolean isByte(JType type) {
        if (type != null) {
            JPrimitiveType primitive = type.isPrimitive();
            return primitive != null && primitive.equals((Object)JPrimitiveType.BYTE) || type.getQualifiedSourceName().equals(Byte.class.getName());
        }
        return false;
    }

    public static boolean isCharacter(JType type) {
        if (type != null) {
            JPrimitiveType primitive = type.isPrimitive();
            return primitive != null && primitive.equals((Object)JPrimitiveType.CHAR) || type.getQualifiedSourceName().equals(Character.class.getName());
        }
        return false;
    }

    public static boolean isDate(JType type) {
        if (type != null) {
            return type.getQualifiedSourceName().equals(java.util.Date.class.getName()) || type.getQualifiedSourceName().equals(Date.class.getName()) || type.getQualifiedSourceName().equals(Time.class.getName()) || type.getQualifiedSourceName().equals(Timestamp.class.getName());
        }
        return false;
    }

    public static boolean isDouble(JType type) {
        if (type != null) {
            JPrimitiveType primitive = type.isPrimitive();
            return primitive != null && primitive.equals((Object)JPrimitiveType.DOUBLE) || type.getQualifiedSourceName().equals(Double.class.getName());
        }
        return false;
    }

    public static boolean isFloat(JType type) {
        if (type != null) {
            JPrimitiveType primitive = type.isPrimitive();
            return primitive != null && primitive.equals((Object)JPrimitiveType.FLOAT) || type.getQualifiedSourceName().equals(Float.class.getName());
        }
        return false;
    }

    public static boolean isInteger(JType type) {
        if (type != null) {
            JPrimitiveType primitive = type.isPrimitive();
            return primitive != null && primitive.equals((Object)JPrimitiveType.INT) || type.getQualifiedSourceName().equals(Integer.class.getName());
        }
        return false;
    }

    public static boolean isLong(JType type) {
        if (type != null) {
            JPrimitiveType primitive = type.isPrimitive();
            return primitive != null && primitive.equals((Object)JPrimitiveType.LONG) || type.getQualifiedSourceName().equals(Long.class.getName());
        }
        return false;
    }

    public static boolean isShort(JType type) {
        if (type != null) {
            JPrimitiveType primitive = type.isPrimitive();
            return primitive != null && primitive.equals((Object)JPrimitiveType.SHORT) || type.getQualifiedSourceName().equals(Short.class.getName());
        }
        return false;
    }

    public static boolean isString(JType type) {
        if (type != null) {
            return type.getQualifiedSourceName().equals(String.class.getName());
        }
        return false;
    }

    public static boolean isNumeric(JType type) {
        return TypeUtils.isByte(type) || TypeUtils.isShort(type) || TypeUtils.isInteger(type) || TypeUtils.isLong(type) || TypeUtils.isFloat(type) || TypeUtils.isDouble(type);
    }

    public static boolean isCollection(JType type) {
        return Collection.class.getName().equals(type.getQualifiedSourceName()) || List.class.getName().equals(type.getQualifiedSourceName()) || ArrayList.class.getName().equals(type.getQualifiedSourceName()) || LinkedList.class.getName().equals(type.getQualifiedSourceName()) || Set.class.getName().equals(type.getQualifiedSourceName()) || HashSet.class.getName().equals(type.getQualifiedSourceName()) || LinkedHashSet.class.getName().equals(type.getQualifiedSourceName()) || SortedSet.class.getName().equals(type.getQualifiedSourceName()) || TreeSet.class.getName().equals(type.getQualifiedSourceName());
    }

    public static boolean isMap(JType type) {
        return Map.class.getName().equals(type.getQualifiedSourceName()) || HashMap.class.getName().equals(type.getQualifiedSourceName()) || SortedMap.class.getName().equals(type.getQualifiedSourceName()) || TreeMap.class.getName().equals(type.getQualifiedSourceName());
    }

    public static boolean isJavaType(JType type) {
        if (type != null) {
            return type.getQualifiedSourceName().startsWith("java.") || type.getQualifiedSourceName().startsWith("javax.");
        }
        return false;
    }

    public static boolean isGwtType(JType type) {
        if (type != null) {
            return type.getQualifiedSourceName().startsWith("com.google.gwt.");
        }
        return false;
    }

    public static boolean canContainId(JType type) {
        if (type != null) {
            return !TypeUtils.isBoolean(type) && !TypeUtils.isNumeric(type) && !TypeUtils.isCharacter(type) && !TypeUtils.isString(type) && type.isEnum() == null && !TypeUtils.isDate(type) && type.isArray() == null && !TypeUtils.isCollection(type) && !TypeUtils.isJavaType(type) && !TypeUtils.isGwtType(type);
        }
        return false;
    }

    public static String collectionImplementationFor(String classname) {
        String impl = interfaceToImplementation.get(classname);
        if (impl != null) {
            return impl;
        }
        return classname;
    }

    public static JClassType getTypeVariable(JType type) {
        JClassType[] typeArgs;
        JClassType parameterType = null;
        JParameterizedType parameterizedType = type.isParameterized();
        if (parameterizedType != null && (typeArgs = parameterizedType.getTypeArgs()) != null && typeArgs.length > 0) {
            parameterType = typeArgs[0];
        }
        return parameterType;
    }

    public static void collectConcreteTypes(List<JClassType> concreteTypes, JType type) {
        JClassType classOrInterface;
        if (type != null && (classOrInterface = type.isClassOrInterface()) != null) {
            if (classOrInterface.isAbstract() || classOrInterface.isInterface() != null) {
                JClassType[] subtypes = classOrInterface.getSubtypes();
                if (subtypes != null && subtypes.length != 0) {
                    for (JClassType subtype : subtypes) {
                        TypeUtils.collectConcreteTypes(concreteTypes, (JType)subtype);
                    }
                }
            } else if (!TypeUtils.isJavaType((JType)classOrInterface) && !TypeUtils.isGwtType((JType)classOrInterface) && type.isEnum() == null && TypeUtils.isDefaultInstantiable((JType)classOrInterface)) {
                concreteTypes.add(classOrInterface);
            }
        }
    }

    public static boolean isDefaultInstantiable(JType type) {
        if (type == null) {
            return false;
        }
        JClassType classType = type.isClass();
        if (classType == null) {
            return false;
        }
        return classType.isDefaultInstantiable();
    }

    public static JField findField(JClassType type, String property, Modifier ... modifiers) {
        JField field = null;
        if (type != null && property != null && property.length() != 0) {
            field = type.findField(property);
            if (field == null && type.getEnclosingType() != null) {
                field = type.getEnclosingType().findField(property);
            }
            if (field != null) {
                boolean accessible = true;
                if (modifiers != null && modifiers.length != 0) {
                    accessible = false;
                    for (Modifier modifier : modifiers) {
                        switch (modifier) {
                            case PRIVATE: {
                                accessible = field.isPrivate();
                                break;
                            }
                            case DEFAULT: {
                                accessible = field.isDefaultAccess();
                                break;
                            }
                            case PROTECTED: {
                                accessible = field.isProtected();
                                break;
                            }
                            case PUBLIC: {
                                accessible = field.isPublic();
                                break;
                            }
                        }
                        if (accessible) break;
                    }
                }
                if (!accessible) {
                    field = TypeUtils.findField(type.getSuperclass(), property, modifiers);
                }
            } else {
                field = TypeUtils.findField(type.getSuperclass(), property, modifiers);
            }
        }
        return field;
    }

    public static JMethod findGetter(JClassType type, String property, JType returnType, Modifier ... modifiers) {
        String methodName;
        String[] methodNames;
        JMethod getter = null;
        String[] arr$ = methodNames = new String[]{"get" + property.substring(0, 1).toUpperCase() + property.substring(1), "is" + property.substring(0, 1).toUpperCase() + property.substring(1)};
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (getter = TypeUtils.findMethod(type, returnType, methodName = arr$[i$], new JType[0], modifiers)) == null; ++i$) {
        }
        return getter;
    }

    public static JMethod findSetter(JClassType type, String property, JType parameter, Modifier ... modifiers) {
        String methodName = "set" + property.substring(0, 1).toUpperCase() + property.substring(1);
        return TypeUtils.findMethod(type, (JType)JPrimitiveType.VOID, methodName, new JType[]{parameter}, modifiers);
    }

    public static String getReaderOrWriterImplQualifiedName(TypeOracle typeOracle, JClassType paramType, String readerOrWriterInterfaceName) {
        JGenericType type = typeOracle.findType(readerOrWriterInterfaceName).isGenericType();
        JParameterizedType parameterizedType = typeOracle.getParameterizedType(type, new JClassType[]{paramType});
        JClassType implType = null;
        for (JClassType t : typeOracle.getTypes()) {
            if (!t.isAssignableTo((JClassType)parameterizedType)) continue;
            implType = t;
            break;
        }
        if (implType != null) {
            return implType.getQualifiedSourceName();
        }
        return null;
    }

    private static JMethod findMethod(JClassType type, JType returnType, String name, JType[] parameter, Modifier ... modifiers) {
        JMethod method = null;
        if (type != null && returnType != null && name != null && name.length() != 0 && parameter != null) {
            method = type.findMethod(name, parameter);
            if (method != null && method.getReturnType() == returnType) {
                boolean accessible = true;
                if (modifiers != null && modifiers.length != 0) {
                    accessible = false;
                    for (Modifier modifier : modifiers) {
                        switch (modifier) {
                            case PRIVATE: {
                                accessible = method.isPrivate();
                                break;
                            }
                            case DEFAULT: {
                                accessible = method.isDefaultAccess();
                                break;
                            }
                            case PROTECTED: {
                                accessible = method.isProtected();
                                break;
                            }
                            case PUBLIC: {
                                accessible = method.isPublic();
                                break;
                            }
                        }
                        if (accessible) break;
                    }
                }
                if (!accessible) {
                    method = TypeUtils.findMethod(type.getSuperclass(), returnType, name, parameter, modifiers);
                }
            } else {
                method = TypeUtils.findMethod(type.getSuperclass(), returnType, name, parameter, modifiers);
            }
        }
        return method;
    }

    static {
        interfaceToImplementation.put(Collection.class.getName(), ArrayList.class.getName());
        interfaceToImplementation.put(List.class.getName(), ArrayList.class.getName());
        interfaceToImplementation.put(Set.class.getName(), HashSet.class.getName());
        interfaceToImplementation.put(SortedSet.class.getName(), TreeSet.class.getName());
        interfaceToImplementation.put(Map.class.getName(), HashMap.class.getName());
    }
}

