package name.pehl.piriti.commons.client;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Annotation to select an identifier for a POJO. The annotation can only be
 * specified for one property in the POJOs hirarchy. The properties type must be
 * string.
 * 
 * @see IdRef
 * @author $LastChangedBy: harald.pehl $
 * @version $LastChangedRevision: 82 $
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.FIELD)
public @interface Id
{
    /**
     * A path to select the id
     * 
     * @return
     */
    String value() default "@id";
}
