package name.pehl.totoe.xml.client;

import java.util.List;
import java.util.Map;

/**
 * The Element interface represents an element in an XML document. Elements may
 * have attributes associated with them. There are methods on the Element
 * interface to retrieve either an {@linkplain Attribute attribute instance} or
 * attribute value by name.
 * <p>
 * This interface implements {@link HasText} and returns the text of the first
 * child in case the first child itself implements {@link HasText}. In all other
 * cases the {@link HasText#getText()} method returns <code>null</code> .
 * 
 * @author $Author: harald.pehl $
 * @version $Date: 2010-10-26 14:04:16 +0200 (Di, 26 Okt 2010) $ $Revision: 78
 *          $
 */
public interface Element extends Node, HasChildren, HasText
{
    /**
     * Returns the specifed attribute.
     * 
     * @w3cDiff This method refers to the method <code>getAttributeNode()</code>
     *          in the DOM Level 2 specification.
     * @param name
     *            The name of the attribute
     * @return the attribute or <code>null</code> if no such attribute was
     *         found.
     */
    Attribute getAttribute(String name);


    /**
     * Returns the value of the specifed attribute.
     * 
     * @w3cDiff This method refers to the method <code>getAttribute()</code> in
     *          the DOM Level 2 specification.
     * @param name
     *            The name of the attribute
     * @return the value of the attribute or <code>null</code> if no such
     *         attribute was found.
     */
    String getAttributeValue(String name);


    /**
     * Returns <code>true</code> if the element has the specified attribute,
     * <code>false</code> otherwise.
     * 
     * @return <code>true</code> if the element has the specified attribute,
     *         <code>false</code> otherwise.
     */
    boolean hasAttribute(String name);


    /**
     * Returns all attributes.
     * 
     * @return all attributes or an empty list if no attributes are given.
     */
    List<Attribute> getAttributes();


    /**
     * Returns all attribute values with the name as key and the value as value.
     * 
     * @return all attribute values or an empty map if no attributes are given.
     */
    Map<String, String> getAttributeValues();


    /**
     * Returns <code>true</code> if the element has attributes,
     * <code>false</code> otherwise.
     * 
     * @return <code>true</code> if the element has attributes,
     *         <code>false</code> otherwise.
     */
    boolean hasAttributes();
}
