package name.pehl.totoe.xml.client;

/**
 * This interface represents an entity, either parsed or unparsed, in an XML
 * document. Note that this models the entity itself not the entity declaration.
 * 
 * @author $Author: harald.pehl $
 * @version $Date: 2010-10-26 14:04:16 +0200 (Di, 26 Okt 2010) $ $Revision: 174 $
 */
public interface Entity extends Node
{
    /**
     * Returns the public identifier.
     * 
     * @return the public identifier
     */
    String getPublicId();


    /**
     * Returns the system identifier.
     * 
     * @return the system identifier.
     */
    String getSystemId();


    /**
     * Returns the notation name. For unparsed entities this is the name of the
     * notation for the entity. For parsed entities, this is null.
     * 
     * @return the notation name.
     */
    String getNotationName();
}
