package name.pehl.totoe.xml.client;

/**
 * The Attribute interface represents an attribute in an {@link Element} object.
 * <p>
 * Attribute objects inherit the {@link Node} interface, but since they are not
 * actually child nodes of the element they describe, the DOM does not consider
 * them part of the document tree. Thus, the {@link Node} methods
 * {@link Node#getParent()}, {@link Node#getPreviousSibling()}, and
 * {@link Node#getNextSibling()} all return <code>null</code> for Attribute
 * instances.
 * <p>
 * Attribute extends {@link HasText}. To get the value of the attribute use {@link HasText#getText()}.
 * 
 * @author $Author: harald.pehl $
 * @version $Date: 2010-10-26 14:04:16 +0200 (Di, 26 Okt 2010) $ $Revision: 43
 *          $
 */
public interface Attribute extends Node, HasText
{
    /**
     * Returns the element this attribute belongs to.
     * 
     * @userAgent Not available in IE6 and 7
     * @return the element this attribute belongs to.
     */
    Element getElement();
}
