package name.pehl.totoe.xml.client.internal;

import java.util.List;

import name.pehl.totoe.xml.client.DocumentFragment;
import name.pehl.totoe.xml.client.Node;
import name.pehl.totoe.xml.client.NodeType;

import com.google.gwt.core.client.JavaScriptObject;

/**
 * @author $Author: harald.pehl $
 * @version $Date: 2010-10-26 14:04:16 +0200 (Di, 26 Okt 2010) $ $Revision: 174 $
 */
public class DocumentFragmentImpl extends NodeImpl implements DocumentFragment
{
    // ----------------------------------------------------------- constructors

    protected DocumentFragmentImpl(JavaScriptObject jso)
    {
        super(jso);
    }


    // ----------------------------------------------------------------- parent

    /**
     * Always returns <code>null</code>.
     * 
     * @return <code>null</code>
     * @see name.pehl.totoe.xml.client.internal.NodeImpl#getParent()
     */
    @Override
    public Node getParent()
    {
        return null;
    }


    // --------------------------------------------------------------- children

    @Override
    public List<Node> getChildren()
    {
        return XmlParserUtils.getChildren(jso);
    }


    @Override
    public <T extends Node> List<T> getChildren(NodeType type)
    {
        return XmlParserUtils.getChildren(jso, type);
    }


    @Override
    public boolean hasChildren()
    {
        return XmlParserUtils.hasChildren(jso);
    }


    @Override
    public boolean hasChildren(NodeType type)
    {
        return XmlParserUtils.hasChildren(jso, type);
    }


    @Override
    public Node getFirstChild()
    {
        return XmlParserUtils.getFirstChild(jso);
    }


    @Override
    public Node getLastChild()
    {
        return XmlParserUtils.getLastChild(jso);
    }
}
