/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.nanning.cache;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.nanning.Invocation;
import org.codehaus.nanning.MethodInterceptor;

public class CacheInterceptor
implements MethodInterceptor {
    private Map cache = new HashMap();

    public Object invoke(Invocation invocation) throws Throwable {
        List<Object> args;
        Method method = invocation.getMethod();
        Map methodCache = this.getMethodCache(method);
        Object cachedResult = methodCache.get(args = Arrays.asList(invocation.getArgs()));
        if (cachedResult == null) {
            cachedResult = invocation.invokeNext();
            methodCache.put(args, cachedResult);
        }
        return cachedResult;
    }

    private Map getMethodCache(Method method) {
        HashMap methodCache = (HashMap)this.cache.get(method);
        if (methodCache == null) {
            methodCache = new HashMap();
            this.cache.put(method, methodCache);
        }
        return methodCache;
    }

    public void clearCache() {
        this.cache.clear();
    }
}

