/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.nanning.contract;

import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ognl.MethodFailedException;
import ognl.Ognl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.nanning.Invocation;
import org.codehaus.nanning.MethodInterceptor;
import org.codehaus.nanning.attribute.Attributes;

public class ContractInterceptor
implements MethodInterceptor {
    private static final Log logger = LogFactory.getLog((Class)(class$org$codehaus$nanning$contract$ContractInterceptor == null ? (class$org$codehaus$nanning$contract$ContractInterceptor = ContractInterceptor.class$("org.codehaus.nanning.contract.ContractInterceptor")) : class$org$codehaus$nanning$contract$ContractInterceptor));
    private static final Pattern oldPattern = Pattern.compile("(.*)\\{old (.*?)}(.*)");
    private ThreadLocal checkContracts = new ThreadLocal();
    static /* synthetic */ Class class$org$codehaus$nanning$contract$ContractInterceptor;

    public Object invoke(Invocation invocation) throws Throwable {
        String ensures = Attributes.getAttribute((Method)invocation.getMethod(), (String)"ensures");
        String requires = Attributes.getAttribute((Method)invocation.getMethod(), (String)"requires");
        String invariant = Attributes.getAttribute(invocation.getMethod().getDeclaringClass(), (String)"invariant");
        StringBuffer parsedEnsure = null;
        ArrayList<Object> oldValues = null;
        if (this.checkContracts.get() == null) {
            this.assertExpressionTrue(invocation, requires, "precondition violated: {0}");
            if (ensures != null) {
                oldValues = new ArrayList<Object>();
                parsedEnsure = new StringBuffer();
                Matcher matcher = oldPattern.matcher(ensures);
                while (matcher.matches()) {
                    String head = matcher.group(1);
                    String old = matcher.group(2);
                    String tail = matcher.group(3);
                    oldValues.add(this.executeExpression(invocation, old));
                    String oldRef = "#" + ContractInterceptor.getOldReference(oldValues.size() - 1);
                    parsedEnsure.append(head + oldRef + tail);
                    matcher = oldPattern.matcher(tail);
                }
                if (oldValues.size() == 0) {
                    parsedEnsure.append(ensures);
                }
            }
        }
        Object result = invocation.invokeNext();
        if (this.checkContracts.get() == null) {
            if (parsedEnsure != null) {
                Map context = ContractInterceptor.createContext(invocation);
                ListIterator iterator = oldValues.listIterator();
                while (iterator.hasNext()) {
                    Object oldValue = iterator.next();
                    context.put(ContractInterceptor.getOldReference(iterator.previousIndex()), oldValue);
                }
                this.assertExpressionTrue(parsedEnsure.toString(), invocation.getProxy(), context, "postcondition violated: " + ensures);
            }
            this.assertExpressionTrue(invocation, invariant, "invariant violated: {0}");
        }
        return result;
    }

    private static String getOldReference(int i) {
        return "old" + i;
    }

    private Object executeExpression(Invocation invocation, String expression) {
        Map context = ContractInterceptor.createContext(invocation);
        try {
            return ContractInterceptor.executeExpression(expression, invocation.getProxy(), context);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not execute: " + expression, e);
        }
    }

    private void assertExpressionTrue(Invocation invocation, String expression, String message) {
        if (expression != null) {
            Map context = ContractInterceptor.createContext(invocation);
            this.assertExpressionTrue(expression, invocation.getProxy(), context, MessageFormat.format(message, expression));
        }
    }

    private static Map createContext(Invocation invocation) {
        Map variables = Ognl.createDefaultContext((Object)invocation.getProxy());
        variables.put("this", invocation.getProxy());
        Object[] args = invocation.getArgs();
        if (args != null) {
            int i = 0;
            while (i < args.length) {
                Object arg = args[i];
                variables.put("arg" + i, arg);
                ++i;
            }
        }
        return variables;
    }

    private void assertExpressionTrue(String expression, Object root, Map context, String message) {
        if (this.checkContracts.get() == null) {
            this.checkContracts.set(this.checkContracts);
            try {
                try {
                    Boolean aBoolean = (Boolean)ContractInterceptor.executeExpression(expression, root, context);
                    boolean result = aBoolean;
                    if (!result) {
                        throw new AssertionError((Object)message);
                    }
                    Object var8_9 = null;
                    this.checkContracts.set(null);
                }
                catch (MethodFailedException e) {
                    if (e.getReason() instanceof Error) {
                        throw (Error)e.getReason();
                    }
                    logger.error((Object)("Could not execute expression: " + expression));
                    throw new AssertionError((Object)("Could not execute expression: " + expression));
                }
                catch (Exception e) {
                    logger.error((Object)("Could not execute expression: " + expression));
                    throw new AssertionError((Object)("Could not execute expression: " + expression));
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                this.checkContracts.set(null);
                throw throwable;
            }
        }
    }

    private static Object executeExpression(String expression, Object root, Map context) throws Exception {
        return Ognl.getValue((Object)Ognl.parseExpression((String)expression), (Map)context, (Object)root);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

