/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.http;

import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.Optional;
import net.anwiba.commons.http.HttpConnectionMode;
import net.anwiba.commons.http.IAuthentication;
import net.anwiba.commons.http.IHttpClientFactory;
import net.anwiba.commons.http.IHttpRequestExecutor;
import net.anwiba.commons.http.IRequest;
import net.anwiba.commons.http.IResponse;
import net.anwiba.commons.http.Response;
import net.anwiba.commons.http.apache.InputStreamEntity;
import net.anwiba.commons.lang.exception.UnreachableCodeReachedException;
import net.anwiba.commons.lang.functional.IWatcher;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.thread.cancel.ICanceler;
import net.anwiba.commons.utilities.parameter.IParameter;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.HttpContext;

public class HttpRequestExecutor
implements IHttpRequestExecutor {
    private static ILogger logger = Logging.getLogger((String)HttpRequestExecutor.class.getName());
    private CloseableHttpClient client;
    private IHttpClientFactory httpClientFactory;
    private boolean isClosed = false;
    private final HttpConnectionMode httpConnectionMode;

    HttpRequestExecutor(HttpConnectionMode httpConnectionMode, IHttpClientFactory httpClientFactory) {
        this.httpConnectionMode = httpConnectionMode;
        this.httpClientFactory = httpClientFactory;
    }

    @Override
    public IResponse execute(ICanceler canceler, IRequest request) throws InterruptedException, IOException {
        if (this.isClosed) {
            throw new IOException("executor is closed");
        }
        HttpUriRequest method = this.create(request);
        try {
            logger.log(ILevel.DEBUG, () -> MessageFormat.format("request url: <{0}>", method.getURI()));
            canceler.check();
            this.client = this.client == null ? this.httpClientFactory.create() : this.client;
            HttpResponse httpResponse = this.query(canceler, this.client, request, method);
            if (HttpConnectionMode.CLOSE.equals((Object)this.httpClientFactory.getClientConfiguration().getMode())) {
                Response response = new Response(canceler, (Closeable)this.client, method, httpResponse);
                this.client = null;
                return response;
            }
            return new Response(canceler, () -> {}, method, httpResponse);
        }
        catch (IllegalStateException exception) {
            logger.log(ILevel.ALL, exception.getMessage(), (Throwable)exception);
            throw new InterruptedException(exception.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private HttpResponse query(ICanceler canceler, CloseableHttpClient httpClient, IRequest request, HttpUriRequest method) throws IOException, ClientProtocolException {
        Throwable throwable = null;
        Object var6_7 = null;
        try {
            CloseableHttpResponse closeableHttpResponse;
            IWatcher watcher = (IWatcher)canceler.watcherFactory().create(() -> method.abort());
            try {
                if (request.getAuthentication() != null) {
                    closeableHttpResponse = httpClient.execute(method, this.createContext(request));
                    return closeableHttpResponse;
                }
                return httpClient.execute(method);
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                if (watcher == null) return closeableHttpResponse;
                watcher.close();
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }

    private HttpContext createContext(IRequest request) {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        IAuthentication authentication = request.getAuthentication();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(authentication.getUsername(), authentication.getPassword()));
        BasicAuthCache authCache = new BasicAuthCache();
        authCache.put(new HttpHost(request.getHost(), request.getPort(), request.getUriString().toLowerCase().startsWith("https:") ? "https" : "http"), (AuthScheme)new BasicScheme());
        HttpClientContext context = HttpClientContext.create();
        context.setCredentialsProvider((CredentialsProvider)credentialsProvider);
        context.setAuthCache((AuthCache)authCache);
        return context;
    }

    private HttpUriRequest create(IRequest request) {
        switch (request.getMethodType()) {
            case POST: {
                RequestBuilder requestBuilder = RequestBuilder.post((String)request.getUriString());
                this.addToQuery(request, requestBuilder);
                this.addToHeader(request.getProperties().parameters(), requestBuilder);
                Optional.ofNullable(request.getUserAgent()).ifPresent(value -> {
                    RequestBuilder requestBuilder2 = requestBuilder.addHeader("User-Agent", value);
                });
                HttpEntity entity = this.createEntity(request);
                requestBuilder.setEntity(entity);
                return requestBuilder.build();
            }
            case GET: {
                RequestBuilder requestBuilder = RequestBuilder.get((String)request.getUriString());
                this.addToQuery(request, requestBuilder);
                this.addToHeader(request.getProperties().parameters(), requestBuilder);
                Optional.ofNullable(request.getUserAgent()).ifPresent(value -> {
                    RequestBuilder requestBuilder2 = requestBuilder.addHeader("User-Agent", value);
                });
                return requestBuilder.build();
            }
        }
        throw new UnreachableCodeReachedException();
    }

    private void addToQuery(IRequest request, RequestBuilder requestBuilder) {
        for (IParameter parameter : request.getParameters().parameters()) {
            requestBuilder.addParameter(parameter.getName(), parameter.getValue());
        }
    }

    private void addToHeader(Iterable<IParameter> parameters, RequestBuilder requestBuilder) {
        for (IParameter parameter : parameters) {
            if (Objects.equals("Connection", parameter.getName()) && HttpConnectionMode.CLOSE.equals((Object)this.httpConnectionMode)) continue;
            requestBuilder.addHeader(parameter.getName(), parameter.getValue());
        }
        if (HttpConnectionMode.CLOSE.equals((Object)this.httpConnectionMode)) {
            requestBuilder.addHeader("Connection", "Close");
        }
    }

    private HttpEntity createEntity(IRequest request) {
        String encoding = request.getEncoding();
        Charset charset = encoding == null ? null : Charset.forName(encoding);
        ContentType contentType = ContentType.create((String)request.getMimeType(), (Charset)charset);
        return new InputStreamEntity(request.getContent(), request.getContentLength(), contentType);
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        try {
            if (this.client == null) {
                return;
            }
            this.client.close();
        }
        finally {
            this.isClosed = true;
            this.httpClientFactory = null;
            this.client = null;
        }
    }
}

