/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.http;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.activation.MimeType;
import javax.activation.MimeTypeParameterList;
import javax.activation.MimeTypeParseException;
import net.anwiba.commons.http.CancelableInputStream;
import net.anwiba.commons.http.IResponse;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.reference.utilities.IoUtilities;
import net.anwiba.commons.thread.cancel.ICanceler;
import net.anwiba.commons.utilities.string.StringUtilities;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;

public final class Response
implements IResponse {
    private final HttpResponse response;
    private final ICanceler cancelable;
    private final HttpUriRequest request;
    private final Closeable client;

    public Response(ICanceler cancelable, Closeable client, HttpUriRequest request, HttpResponse response) {
        this.cancelable = cancelable;
        this.client = client;
        this.request = request;
        this.response = response;
    }

    @Override
    public URI getUri() {
        return this.request.getURI();
    }

    @Override
    public String getBody() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (InputStream inputStream = this.getInputStream();){
            return IoUtilities.toString(inputStream, this.getContentEncoding());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public int getStatusCode() {
        return (Integer)Optional.of((Object)this.response).convert(r -> r.getStatusLine()).convert(l -> l.getStatusCode()).getOr(() -> 404);
    }

    @Override
    public String getStatusText() {
        return (String)Optional.of((Object)this.response).convert(r -> r.getStatusLine()).convert(l -> l.getReasonPhrase()).getOr(() -> "");
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new CancelableInputStream(this.cancelable, (InputStream)Optional.create((Object)this.response).convert(r -> r.getEntity()).convert(e -> e.getContent()).getOrThrow(() -> new IOException()));
    }

    @Override
    public long getContentLength() {
        return (Long)Optional.of((Object)this.response).convert(r -> r.getEntity()).convert(e -> e.getContentLength()).getOr(() -> 0L);
    }

    @Override
    public String getContentType() {
        return (String)Optional.of((Object)this.response).convert(r -> r.getEntity()).convert(e -> e.getContentType()).convert(h -> h.getValue()).get();
    }

    @Override
    public String getContentEncoding() {
        return (String)Optional.of((Object)this.response).convert(r -> r.getEntity()).convert(e -> e.getContentEncoding()).convert(h -> h.getValue()).getOr(() -> this.getContentEncodingfromContentType());
    }

    private String getContentEncodingfromContentType() {
        String charset;
        block5: {
            String contentType;
            block4: {
                try {
                    contentType = this.getContentType();
                    if (!StringUtilities.isNullOrTrimmedEmpty((String)contentType)) break block4;
                    return "UTF-8";
                }
                catch (MimeTypeParseException mimeTypeParseException) {
                    return "UTF-8";
                }
            }
            MimeType mimeType = new MimeType(contentType);
            MimeTypeParameterList parameters = mimeType.getParameters();
            charset = parameters.get("charset");
            if (!StringUtilities.isNullOrTrimmedEmpty((String)charset)) break block5;
            return "UTF-8";
        }
        return charset;
    }

    @Override
    public void close() throws IOException {
        IOException exception = null;
        if (this.response instanceof CloseableHttpResponse) {
            exception = IoUtilities.close(() -> ((CloseableHttpResponse)this.response).close(), exception);
        }
        exception = IoUtilities.close(this.client, exception);
        IoUtilities.toss(exception);
    }
}

