/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.image;

import java.io.File;
import javax.swing.filechooser.FileFilter;
import net.anwiba.commons.image.codec.ImageCodec;
import net.anwiba.commons.reference.utilities.FileUtilities;

public class ImageFileFilter
extends FileFilter {
    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        return this.isImage(file);
    }

    public boolean isImage(File file) {
        if (file == null || file.isDirectory()) {
            return false;
        }
        String extension = FileUtilities.getExtension(file);
        return extension != null && ImageCodec.getByExtension(extension) != ImageCodec.UNKNOWN;
    }

    @Override
    public String getDescription() {
        return "Image (*.bmp, *.gif, *.png, *.jpg, *.tiff)";
    }
}

