/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.jdbc.connection;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.anwiba.commons.jdbc.connection.DefaultDatabaseConnector;
import net.anwiba.commons.jdbc.connection.IDatabaseConnector;
import net.anwiba.commons.jdbc.connection.IDatabaseConnectorRegistry;
import net.anwiba.commons.jdbc.connection.IJdbcConnectionDescription;
import net.anwiba.commons.jdbc.connection.IPostConnectionProcedure;
import net.anwiba.commons.jdbc.connection.IRegisterableDatabaseConnector;
import net.anwiba.commons.jdbc.connection.WrappingConnection;
import net.anwiba.commons.lang.functional.IApplicable;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.lang.stream.Streams;
import net.anwiba.commons.utilities.registry.AbstractApplicableRegistry;

public class DatabaseConnectorRegistry
implements IDatabaseConnectorRegistry {
    private final List<IPostConnectionProcedure> procedures = new ArrayList<IPostConnectionProcedure>();
    private final AbstractApplicableRegistry<String, IRegisterableDatabaseConnector> registry = new AbstractApplicableRegistry((IApplicable)new DefaultDatabaseConnector());

    @Override
    public Connection connectReadOnly(IJdbcConnectionDescription description) throws SQLException {
        return this.connectReadOnly(description, -1);
    }

    @Override
    public Connection connectReadOnly(IJdbcConnectionDescription description, int timeout) throws SQLException {
        return this.connectReadOnly(description.getUrl(), description.getUserName(), description.getPassword(), timeout);
    }

    @Override
    public Connection connectReadOnly(String url, String userName, String password, int timeout) throws SQLException {
        return this.connect(url, userName, password, timeout, true);
    }

    @Override
    public Connection connectWritable(IJdbcConnectionDescription description) throws SQLException {
        return this.connectWritable(description, -1);
    }

    @Override
    public Connection connectWritable(IJdbcConnectionDescription description, int timeout) throws SQLException {
        return this.connectWritable(description.getUrl(), description.getUserName(), description.getPassword(), timeout);
    }

    @Override
    public Connection connectWritable(String url, String userName, String password, int timeout) throws SQLException {
        return this.connect(url, userName, password, timeout, false);
    }

    public Connection connect(String url, String userName, String password, int timeout, boolean isReadOnly) throws SQLException {
        IDatabaseConnector connector = (IDatabaseConnector)this.registry.get((Object)url);
        Connection connection = isReadOnly ? connector.connectReadOnly(url, userName, password, timeout) : connector.connectWritable(url, userName, password, timeout);
        connection.setAutoCommit(true);
        connection.clearWarnings();
        this.setUp((Connection)Optional.of((Object)connection).instanceOf(WrappingConnection.class).convert(w -> w.getConnection()).getOr(() -> connection));
        return connection;
    }

    private void setUp(Connection connection) throws SQLException {
        Streams.create(this.procedures).filter(p -> p.isApplicable(connection)).foreach(p -> p.execute(connection));
    }

    @Override
    public void add(IPostConnectionProcedure procedure) {
        this.procedures.add(procedure);
    }

    @Override
    public void add(IRegisterableDatabaseConnector connector) {
        this.registry.add((Object[])new IRegisterableDatabaseConnector[]{connector});
    }

    @Override
    public boolean isConnectable(String url, String userName, String password) {
        IDatabaseConnector connector = (IDatabaseConnector)this.registry.get((Object)url);
        return connector.isConnectable(url, userName, password);
    }
}

