/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.jdbc.metadata;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import net.anwiba.commons.jdbc.metadata.IColumnMetaData;
import net.anwiba.commons.lang.exception.UnreachableCodeReachedException;

public class ColumnResultSetMetadata
implements IColumnMetaData {
    private final ResultSetMetaData resultSetMetaData;
    private final int index;

    public ColumnResultSetMetadata(ResultSetMetaData resultSetMetaData, int index) {
        this.resultSetMetaData = resultSetMetaData;
        this.index = index;
    }

    @Override
    public String getColumnName() {
        try {
            return this.resultSetMetaData.getColumnName(this.index);
        }
        catch (SQLException sQLException) {
            throw new UnreachableCodeReachedException();
        }
    }

    @Override
    public int getLength() {
        try {
            int precision = this.resultSetMetaData.getPrecision(this.index);
            return precision > 0 ? precision : -1;
        }
        catch (SQLException sQLException) {
            throw new UnreachableCodeReachedException();
        }
    }

    @Override
    public int getScale() {
        try {
            int scale = this.resultSetMetaData.getScale(this.index);
            return scale >= 0 ? scale : -1;
        }
        catch (SQLException sQLException) {
            throw new UnreachableCodeReachedException();
        }
    }

    @Override
    public String getTypeName() {
        try {
            return this.resultSetMetaData.getColumnTypeName(this.index);
        }
        catch (SQLException sQLException) {
            throw new UnreachableCodeReachedException();
        }
    }

    @Override
    public boolean isKey() {
        try {
            return this.resultSetMetaData.isAutoIncrement(this.index);
        }
        catch (SQLException sQLException) {
            throw new UnreachableCodeReachedException();
        }
    }

    @Override
    public boolean isNullable() {
        try {
            return this.resultSetMetaData.isNullable(this.index) != 0;
        }
        catch (SQLException sQLException) {
            throw new UnreachableCodeReachedException();
        }
    }

    @Override
    public String getLabel() {
        try {
            return this.resultSetMetaData.getColumnLabel(this.index);
        }
        catch (SQLException sQLException) {
            throw new UnreachableCodeReachedException();
        }
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public String getSchemaName() {
        try {
            return this.resultSetMetaData.getSchemaName(this.index);
        }
        catch (SQLException sQLException) {
            throw new UnreachableCodeReachedException();
        }
    }

    @Override
    public String getTableName() {
        try {
            return this.resultSetMetaData.getTableName(this.index);
        }
        catch (SQLException sQLException) {
            throw new UnreachableCodeReachedException();
        }
    }
}

