/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.jdbc.resource;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.utilities.string.StringUtilities;

public abstract class AbstractStatementString {
    static final ILogger logger = Logging.getLogger((String)AbstractStatementString.class.getName());
    private static final String EXTENSION = "sql";
    private static final int MOD_EXPECTED = 9;
    private static final int MOD_MASK = 25;
    private static final Object ASSIGNED = new Object();

    public static void initializeMessages(final Class<?> clazz) {
        if (System.getSecurityManager() == null) {
            AbstractStatementString.load(clazz);
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                AbstractStatementString.load(clazz);
                return null;
            }
        });
    }

    public static String bind(String statement, Object ... bindings) {
        return AbstractStatementString.bind(Locale.getDefault(), statement, bindings);
    }

    public static String bind(Locale local, String statement, Object ... bindings) {
        if (statement == null) {
            return "No statement available.";
        }
        if (bindings.length == 0) {
            return statement;
        }
        return new MessageFormat(AbstractStatementString.doubleQuots(statement.toCharArray()), local).format(bindings);
    }

    private static String doubleQuots(char[] characters) {
        StringBuilder builder = new StringBuilder();
        char[] cArray = characters;
        int n = characters.length;
        int n2 = 0;
        while (n2 < n) {
            char character = cArray[n2];
            if (character == '\'') {
                builder.append(character);
            }
            builder.append(character);
            ++n2;
        }
        return builder.toString();
    }

    private static Map<String, String> buildVariants(String classRoot, Field[] fieldArray) {
        String pathRoot = classRoot.replace('.', '/');
        HashMap<String, String> resources = new HashMap<String, String>();
        Field[] fieldArray2 = fieldArray;
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray2[n2];
            resources.put(field.getName(), String.valueOf(pathRoot) + "/" + field.getName() + "." + EXTENSION);
            ++n2;
        }
        return resources;
    }

    private static void computeMissingStatement(String bundleName, Map<Object, Object> fieldMap, Field[] fieldArray, boolean isAccessible) {
        int numFields = fieldArray.length;
        int i = 0;
        while (i < numFields) {
            Field field = fieldArray[i];
            if ((field.getModifiers() & 0x19) == 9 && fieldMap.get(field.getName()) != ASSIGNED) {
                try {
                    String value = "missing statement: " + field.getName() + " in: " + bundleName;
                    logger.log(ILevel.WARNING, value);
                    if (!isAccessible) {
                        field.setAccessible(true);
                    }
                    field.set(null, value);
                }
                catch (Exception e) {
                    logger.log(ILevel.FATAL, "Error setting the missing statement value for: " + field.getName(), (Throwable)e);
                }
            }
            ++i;
        }
    }

    static void load(Class<?> clazz) {
        Field[] fieldArray = clazz.getDeclaredFields();
        ClassLoader loader = clazz.getClassLoader();
        boolean isAccessible = (clazz.getModifiers() & 1) != 0;
        int len = fieldArray.length;
        HashMap<Object, Object> fields = new HashMap<Object, Object>(len * 2);
        int i = 0;
        while (i < len) {
            fields.put(fieldArray[i].getName(), fieldArray[i]);
            ++i;
        }
        String bundleName = clazz.getPackage().getName();
        Map<String, String> resources = AbstractStatementString.buildVariants(bundleName, fieldArray);
        Field[] fieldArray2 = fieldArray;
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            block15: {
                InputStream input;
                Field field = fieldArray2[n2];
                String element = resources.get(field.getName());
                InputStream inputStream = input = loader == null ? ClassLoader.getSystemResourceAsStream(element) : loader.getResourceAsStream(element);
                if (input == null) {
                    logger.log(Level.SEVERE, "Error loading " + element);
                } else {
                    try {
                        try {
                            String value = AbstractStatementString.readInputStream(input);
                            AbstractStatementString.setValue(fields, field, value, isAccessible);
                        }
                        catch (IOException e) {
                            logger.log(Level.SEVERE, "Error loading " + element, (Throwable)e);
                            try {
                                input.close();
                            }
                            catch (IOException iOException) {}
                            break block15;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            input.close();
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            ++n2;
        }
        AbstractStatementString.computeMissingStatement(clazz.getName(), fields, fieldArray, isAccessible);
    }

    private static synchronized void setValue(Map<Object, Object> fields, Field field, String value, boolean isAccessible) {
        Object fieldObject = fields.put(field.getName(), ASSIGNED);
        if (fieldObject == ASSIGNED) {
            return;
        }
        if (fieldObject == null) {
            String msg = "unused statement: " + field.getName();
            logger.log(ILevel.WARNING, msg);
            return;
        }
        if ((field.getModifiers() & 0x19) != 9) {
            return;
        }
        try {
            if (!isAccessible) {
                field.setAccessible(true);
            }
            String fieldValue = value.replace("\r", "");
            if (field.getType().isArray()) {
                String[] array = AbstractStatementString.createArray(fieldValue);
                field.set(null, array);
                return;
            }
            field.set(null, fieldValue);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception setting field value.", (Throwable)e);
        }
    }

    private static String[] createArray(String fieldValue) {
        ArrayList<String> values = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(fieldValue, ";");
        while (tokenizer.hasMoreElements()) {
            String nextToken = tokenizer.nextToken().trim();
            if (StringUtilities.isNullOrEmpty((String)nextToken)) continue;
            values.add(nextToken);
        }
        return values.toArray(new String[values.size()]);
    }

    private static String readInputStream(InputStream inputStream) throws IOException {
        StringBuffer string = new StringBuffer();
        byte[] buffer = new byte[1024];
        int length = 0;
        while ((length = inputStream.read(buffer)) > -1) {
            string.append(new String(buffer, 0, length));
        }
        return string.toString().trim();
    }
}

