/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.jdbc.resource;

import net.anwiba.commons.lang.exception.CreationException;
import net.anwiba.commons.lang.functional.ResolvingException;
import net.anwiba.commons.utilities.string.IStringAppender;
import net.anwiba.commons.utilities.string.StringAppender;
import net.anwiba.commons.utilities.string.StringResolverBuilder;

public class JdbcServiceUrlStringResolver {
    private static final String PLACEHOLDER_PROTOCOL = "protocol";
    private static final String PLACEHOLDER_DATABASE = "database";
    private static final String PLACEHOLDER_PORT = "port";
    private static final String PLACEHOLDER_HOST = "host";
    private final String urlPattern;

    public JdbcServiceUrlStringResolver(String urlPattern) {
        this.urlPattern = urlPattern;
    }

    public String create(String protocol, String host, String port, String database) throws CreationException {
        StringAppender errorHandler = new StringAppender();
        try {
            String string = (String)new StringResolverBuilder().errorHandler((IStringAppender)errorHandler).optional(PLACEHOLDER_PROTOCOL, protocol).add(PLACEHOLDER_HOST, host).add(PLACEHOLDER_PORT, port).add(PLACEHOLDER_DATABASE, database).build().resolve((Object)this.urlPattern);
            return string;
        }
        catch (ResolvingException resolvingException) {
            throw new CreationException(errorHandler.toString());
        }
        finally {
            if (!errorHandler.isEmpty()) {
                throw new CreationException(errorHandler.toString());
            }
        }
    }
}

