/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.version;

import java.util.GregorianCalendar;
import net.anwiba.commons.utilities.string.StringUtilities;
import net.anwiba.commons.version.IVersion;
import net.anwiba.commons.version.ProductState;
import net.anwiba.commons.version.ReleaseState;
import net.anwiba.commons.version.Version;

public class VersionBuilder {
    private int major = 0;
    private int minor = 0;
    private ReleaseState releaseState = ReleaseState.RELEASE;
    private int step = 0;
    private ProductState productState = ProductState.STABLE;
    private int year = Integer.MIN_VALUE;
    private int month = 0;
    private int day = 0;
    private int hour = 0;
    private int minute = 0;
    private int count = 0;

    public VersionBuilder setMajor(int value) {
        if (value == Integer.MIN_VALUE) {
            this.major = 0;
        }
        this.major = value;
        return this;
    }

    public VersionBuilder setMinor(int value) {
        if (value == Integer.MIN_VALUE) {
            this.minor = 0;
        }
        this.minor = value;
        return this;
    }

    public VersionBuilder setStep(int value) {
        if (value == Integer.MIN_VALUE) {
            this.step = 0;
        }
        this.step = value;
        return this;
    }

    public VersionBuilder setReleaseState(ReleaseState releaseState) {
        this.releaseState = releaseState;
        return this;
    }

    public VersionBuilder setProductState(ProductState productState) {
        this.productState = productState;
        return this;
    }

    public VersionBuilder setYear(int value) {
        if (value == Integer.MIN_VALUE) {
            this.year = 0;
        }
        this.year = value;
        return this;
    }

    public VersionBuilder setMonth(int value) {
        if (value == Integer.MIN_VALUE) {
            this.month = 0;
        }
        this.month = value;
        return this;
    }

    public VersionBuilder setDay(int value) {
        if (value == Integer.MIN_VALUE) {
            this.day = 0;
        }
        this.day = value;
        return this;
    }

    public VersionBuilder setHour(int value) {
        if (value == Integer.MIN_VALUE) {
            this.hour = 0;
        }
        this.hour = value;
        return this;
    }

    public VersionBuilder setMinute(int value) {
        if (value == Integer.MIN_VALUE) {
            this.minute = 0;
        }
        this.minute = value;
        return this;
    }

    public VersionBuilder setCount(int value) {
        if (value == Integer.MIN_VALUE) {
            this.count = 0;
        }
        this.count = value;
        return this;
    }

    public IVersion build() {
        return new Version(this.major, this.minor, this.releaseState, this.step, this.productState, new GregorianCalendar(this.year, this.month - 1, this.day, this.hour, this.minute).getTime(), this.count);
    }

    public VersionBuilder setMajor(String value) {
        this.setMajor(this.convertToInt(value));
        return this;
    }

    public VersionBuilder setMinor(String value) {
        this.setMinor(this.convertToInt(value));
        return this;
    }

    public VersionBuilder setStep(String value) {
        this.setStep(this.convertToInt(value));
        return this;
    }

    public VersionBuilder setYear(String value) {
        this.setStep(this.convertToInt(value));
        return this;
    }

    public VersionBuilder setMonth(String value) {
        this.setStep(this.convertToInt(value));
        return this;
    }

    public VersionBuilder setDay(String value) {
        this.setStep(this.convertToInt(value));
        return this;
    }

    public VersionBuilder setHour(String value) {
        this.setStep(this.convertToInt(value));
        return this;
    }

    public VersionBuilder setMinute(String value) {
        this.setStep(this.convertToInt(value));
        return this;
    }

    public VersionBuilder setCount(String value) {
        this.setCount(this.convertToInt(value));
        return this;
    }

    private int convertToInt(String value) {
        if (StringUtilities.isNullOrTrimmedEmpty((String)value)) {
            return Integer.MIN_VALUE;
        }
        return Integer.valueOf(value.trim());
    }

    public VersionBuilder setProductState(String string) {
        this.productState = ProductState.valueOf(string);
        return this;
    }

    public VersionBuilder setReleaseState(String string) {
        this.releaseState = ReleaseState.valueOf(string);
        return this;
    }
}

