/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.xml.dom;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import net.anwiba.commons.lang.exception.UnreachableCodeReachedException;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.xml.sax.InputSource;

public class DocumentUtilities {
    public static String getDefaultEncoding() {
        return "UTF-8";
    }

    private DocumentUtilities() {
        throw new UnreachableCodeReachedException();
    }

    public static void save(Document document, File file) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            DocumentUtilities.save(document, outputStream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static String toString(Document document) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            DocumentUtilities.save(document, new XMLWriter((OutputStream)outputStream, DocumentUtilities.createTrimedOutputFormat(DocumentUtilities.getDefaultEncoding())));
            return outputStream.toString();
        }
        catch (IOException iOException) {
            throw new UnreachableCodeReachedException();
        }
    }

    private static OutputFormat createTrimedOutputFormat(String encoding) {
        OutputFormat format = OutputFormat.createCompactFormat();
        format.setEncoding(encoding);
        return format;
    }

    public static void save(Document document, OutputStream outputStream) throws IOException {
        DocumentUtilities.save(document, new XMLWriter(outputStream, DocumentUtilities.createOutputFormat()));
    }

    private static void save(Document document, XMLWriter writer) throws IOException {
        try {
            writer.write(document);
            writer.flush();
        }
        catch (UnsupportedEncodingException e) {
            throw new IOException(e.getMessage());
        }
    }

    private static OutputFormat createOutputFormat() {
        return DocumentUtilities.createOutputFormat(DocumentUtilities.getDefaultEncoding());
    }

    private static OutputFormat createOutputFormat(String encoding) {
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding(encoding);
        return format;
    }

    private static Document read(InputSource source) throws IOException {
        try {
            SAXReader saxReader = new SAXReader();
            return saxReader.read(source);
        }
        catch (DocumentException exception) {
            throw new IOException(exception);
        }
    }

    public static Document read(File file) throws IOException {
        try {
            Throwable throwable = null;
            Object var2_5 = null;
            try (FileInputStream inputStream = new FileInputStream(file);){
                InputSource inputSource = new InputSource(inputStream);
                inputSource.setEncoding(DocumentUtilities.getDefaultEncoding());
                return DocumentUtilities.read(inputSource);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException("Error reading xml document from file '" + file.getAbsolutePath() + "'", e);
        }
    }

    public static Document read(InputStream in) throws IOException {
        return DocumentUtilities.read(in, null);
    }

    public static Document read(InputStream inputStream, String systemId) throws IOException {
        try {
            return new SAXReader().read(inputStream, systemId);
        }
        catch (DocumentException exception) {
            throw new IOException(exception);
        }
    }
}

