/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.xmpp.notification;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.Properties;
import net.anwiba.commons.lang.exception.CreationException;
import net.anwiba.commons.lang.exception.InitializeException;
import net.anwiba.commons.message.notification.INotificationReceiver;
import net.anwiba.commons.message.notification.INotificationReceiverFactory;
import net.anwiba.commons.reference.ResourceReferenceFactory;
import net.anwiba.commons.reference.ResourceReferenceUtilities;
import net.anwiba.commons.utilities.string.StringUtilities;
import net.anwiba.commons.xmpp.MessageSenderBuilder;
import net.anwiba.commons.xmpp.SecurityMode;
import net.anwiba.commons.xmpp.notification.XMPPNotificationReceiver;

public class PropertiesXMPPNotificationReceiverFactory
implements INotificationReceiverFactory {
    private static final String XMPP_NOTIFIER_PROPERTIES = "xmpp.notifier.properties";
    private static final String PROPERTY_XMPP_RECEIVER = "xmpp.receiver";
    private static final String PROPERTY_XMPP_RECEIVER_NUMBER = "xmpp.receiver.number";
    private static final String PROPERTY_XMPP_PASSWORD = "xmpp.password";
    private static final String PROPERTY_XMPP_USERNAME = "xmpp.user";
    private static final String PROPERTY_XMPP_HOST = "xmpp.host";

    public INotificationReceiver create() throws CreationException {
        try {
            Properties properties = this.getXmppProperties();
            String host = this.getRequiredProperty(properties, PROPERTY_XMPP_HOST);
            String userName = this.getRequiredProperty(properties, PROPERTY_XMPP_USERNAME);
            String password = this.getRequiredProperty(properties, PROPERTY_XMPP_PASSWORD);
            int numberOfReceivers = Integer.valueOf(this.getRequiredProperty(properties, PROPERTY_XMPP_RECEIVER_NUMBER));
            MessageSenderBuilder builder = new MessageSenderBuilder(host, userName, password);
            builder.setSASLAuthenticationEnabled(true).setSendPresence(false).setSecurityMode(SecurityMode.ENABLE);
            int i = 0;
            while (i < numberOfReceivers) {
                String receiver = this.getRequiredProperty(properties, MessageFormat.format("{0}.{1,number,00}", PROPERTY_XMPP_RECEIVER, i));
                builder.addReceiver(receiver);
                ++i;
            }
            return new XMPPNotificationReceiver(builder.build());
        }
        catch (IOException | InitializeException exception) {
            throw new CreationException(exception.getMessage(), exception);
        }
    }

    private String getRequiredProperty(Properties properties, String propertyName) throws InitializeException {
        String value = properties.getProperty(propertyName);
        if (StringUtilities.isNullOrTrimmedEmpty((String)value)) {
            throw new InitializeException(MessageFormat.format("missing propertie ''{0}''", propertyName));
        }
        return value;
    }

    private Properties getXmppProperties() throws FileNotFoundException, IOException {
        String propertiesFileName = System.getProperty(XMPP_NOTIFIER_PROPERTIES);
        File propertiesFile = PropertiesXMPPNotificationReceiverFactory.getPropertiesFile(propertiesFileName);
        if (propertiesFile == null || !propertiesFile.exists() || !propertiesFile.canRead()) {
            return System.getProperties();
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileReader reader = new FileReader(propertiesFile);){
            Properties properties = new Properties();
            properties.load(reader);
            return properties;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static File getPropertiesFile(String propertiesFileName) throws IOException {
        block3: {
            if (propertiesFileName != null) break block3;
            return null;
        }
        try {
            ResourceReferenceFactory referenceFactory = new ResourceReferenceFactory();
            return ResourceReferenceUtilities.getFile(referenceFactory.create(propertiesFileName));
        }
        catch (URISyntaxException | CreationException exception) {
            throw new IOException(exception.getMessage(), exception);
        }
    }
}

