/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.http;

import java.io.Closeable;
import java.io.IOException;
import java.text.MessageFormat;
import net.anwiba.commons.http.HttpConnectionMode;
import net.anwiba.commons.http.IHttpClientFactory;
import net.anwiba.commons.http.IHttpRequestExecutor;
import net.anwiba.commons.http.IRequest;
import net.anwiba.commons.http.IResponse;
import net.anwiba.commons.http.Response;
import net.anwiba.commons.http.apache.HttpContextFactory;
import net.anwiba.commons.http.apache.RequestToHttpUriRequestConverter;
import net.anwiba.commons.lang.functional.IWatcher;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.thread.cancel.ICanceler;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;

public class HttpRequestExecutor
implements IHttpRequestExecutor {
    private static ILogger logger = Logging.getLogger((String)HttpRequestExecutor.class.getName());
    private CloseableHttpClient client;
    private IHttpClientFactory httpClientFactory;
    private boolean isClosed = false;
    private final RequestToHttpUriRequestConverter requestToHttpUriRequestConverter;
    private final HttpContextFactory httpContectFactory;

    HttpRequestExecutor(HttpConnectionMode httpConnectionMode, IHttpClientFactory httpClientFactory) {
        this.requestToHttpUriRequestConverter = new RequestToHttpUriRequestConverter(httpConnectionMode);
        this.httpContectFactory = new HttpContextFactory();
        this.httpClientFactory = httpClientFactory;
    }

    @Override
    public IResponse execute(ICanceler canceler, IRequest request) throws InterruptedException, IOException {
        if (this.isClosed) {
            throw new IOException("executor is closed");
        }
        HttpUriRequest method = this.requestToHttpUriRequestConverter.convert(request);
        try {
            logger.log(ILevel.DEBUG, () -> MessageFormat.format("request url: <{0}>", method.getURI()));
            canceler.check();
            this.client = this.client == null ? this.httpClientFactory.create() : this.client;
            HttpResponse httpResponse = this.query(canceler, this.client, request, method);
            if (HttpConnectionMode.CLOSE.equals((Object)this.httpClientFactory.getClientConfiguration().getMode())) {
                Response response = new Response(canceler, (Closeable)this.client, method, httpResponse);
                this.client = null;
                return response;
            }
            return new Response(canceler, () -> {}, method, httpResponse);
        }
        catch (IllegalStateException exception) {
            logger.log(ILevel.ALL, exception.getMessage(), (Throwable)exception);
            throw new InterruptedException(exception.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private HttpResponse query(ICanceler canceler, CloseableHttpClient httpClient, IRequest request, HttpUriRequest method) throws IOException, ClientProtocolException {
        Throwable throwable = null;
        Object var6_7 = null;
        try {
            CloseableHttpResponse closeableHttpResponse;
            IWatcher watcher = (IWatcher)canceler.watcherFactory().create(() -> method.abort());
            try {
                if (request.getAuthentication() != null) {
                    closeableHttpResponse = httpClient.execute(method, this.httpContectFactory.create(request));
                    return closeableHttpResponse;
                }
                return httpClient.execute(method);
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                if (watcher == null) return closeableHttpResponse;
                watcher.close();
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        try {
            if (this.client == null) {
                return;
            }
            this.client.close();
        }
        finally {
            this.isClosed = true;
            this.httpClientFactory = null;
            this.client = null;
        }
    }
}

