/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.http;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import net.anwiba.commons.http.ConvertingHttpRequestExecutorBuilder;
import net.anwiba.commons.http.IApplicableHttpResponseExceptionFactory;
import net.anwiba.commons.http.IApplicableResultProducer;
import net.anwiba.commons.http.IConvertingHttpRequestExecutor;
import net.anwiba.commons.http.IHttpResponseExceptionFactory;
import net.anwiba.commons.http.IObjectRequestExecutor;
import net.anwiba.commons.http.IObjectRequestExecutorBuilder;
import net.anwiba.commons.http.IRequest;
import net.anwiba.commons.http.IResultProducer;
import net.anwiba.commons.lang.functional.IApplicable;
import net.anwiba.commons.thread.cancel.ICanceler;

public class ObjectRequestExecutorBuilder<T>
implements IObjectRequestExecutorBuilder<T> {
    private final ConvertingHttpRequestExecutorBuilder builder = new ConvertingHttpRequestExecutorBuilder();
    private final List<IApplicableHttpResponseExceptionFactory> applicableHttpResponseExceptionFactories = new ArrayList<IApplicableHttpResponseExceptionFactory>();
    private final List<IApplicableResultProducer<T>> applicableResultProducers = new ArrayList<IApplicableResultProducer<T>>();

    @Override
    public IObjectRequestExecutorBuilder<T> usePoolingConnection() {
        this.builder.usePoolingConnection();
        return this;
    }

    @Override
    public IObjectRequestExecutorBuilder<T> useAlwaysTheSameConnection() {
        this.builder.useAlwaysTheSameConnection();
        return this;
    }

    @Override
    public IObjectRequestExecutorBuilder<T> useAlwaysANewConnection() {
        this.builder.useAlwaysANewConnection();
        return this;
    }

    @Override
    public IObjectRequestExecutorBuilder<T> setResultProducer(final IResultProducer<T> resultProducer) {
        this.applicableResultProducers.add(new IApplicableResultProducer<T>(){

            @Override
            public T execute(ICanceler canceler, int statusCode, String statusMessage, String contentType, String contentEncoding, InputStream inputStream) throws IOException, InterruptedException {
                return resultProducer.execute(canceler, statusCode, statusMessage, contentType, contentEncoding, inputStream);
            }

            @Override
            public boolean isApplicable(int statusCode, String contentType) {
                return statusCode >= 200 && statusCode < 300;
            }
        });
        return this;
    }

    @Override
    public IObjectRequestExecutorBuilder<T> addExceptionFactory(IApplicableHttpResponseExceptionFactory factory) {
        this.applicableHttpResponseExceptionFactories.add(factory);
        return this;
    }

    @Override
    public IObjectRequestExecutorBuilder<T> addExceptionFactory(final IApplicable<String> applicable, final IHttpResponseExceptionFactory factory) {
        return this.addExceptionFactory(new IApplicableHttpResponseExceptionFactory(){

            @Override
            public IOException create(int statusCode, String statusMessage, String contentEncoding, InputStream inputStream) throws IOException {
                return factory.create(statusCode, statusMessage, contentEncoding, inputStream);
            }

            @Override
            public boolean isApplicable(String contentType) {
                return applicable.isApplicable((Object)contentType);
            }
        });
    }

    @Override
    public IObjectRequestExecutor<T> build() {
        final IConvertingHttpRequestExecutor convertingExecutor = this.builder.build();
        final IApplicableHttpResponseExceptionFactory[] exceptionFactories = (IApplicableHttpResponseExceptionFactory[])this.applicableHttpResponseExceptionFactories.stream().toArray(IApplicableHttpResponseExceptionFactory[]::new);
        return new IObjectRequestExecutor<T>(){

            @Override
            public T execute(ICanceler cancelable, IRequest request) throws InterruptedException, IOException {
                return convertingExecutor.execute(cancelable, request, new IApplicableResultProducer<T>(){

                    @Override
                    public T execute(ICanceler canceler, int statusCode, String statusMessage, String contentType, String contentEncoding, InputStream inputStream) throws IOException, InterruptedException {
                        IApplicableResultProducer producer2;
                        for (IApplicableResultProducer producer2 : ObjectRequestExecutorBuilder.this.applicableResultProducers) {
                            if (!producer2.isApplicable(statusCode, contentType)) continue;
                            return producer2.execute(canceler, statusCode, statusMessage, contentType, contentEncoding, inputStream);
                        }
                        producer2 = (c, sc, sm, t, e, i) -> null;
                        return producer2.execute(canceler, statusCode, statusMessage, contentType, contentEncoding, inputStream);
                    }

                    @Override
                    public boolean isApplicable(int statusCode, String contentType) {
                        for (IApplicableResultProducer producer : ObjectRequestExecutorBuilder.this.applicableResultProducers) {
                            if (!producer.isApplicable(statusCode, contentType)) continue;
                            return true;
                        }
                        return statusCode >= 200 && statusCode < 300;
                    }
                }, exceptionFactories);
            }

            @Override
            public void close() throws IOException {
                convertingExecutor.close();
            }
        };
    }

    @Override
    public IObjectRequestExecutorBuilder<T> addResultProducer(final IApplicable<String> applicable, final IResultProducer<T> resultProducer) {
        this.applicableResultProducers.add(new IApplicableResultProducer<T>(){

            @Override
            public T execute(ICanceler canceler, int statusCode, String statusMessage, String contentType, String contentEncoding, InputStream inputStream) throws IOException, InterruptedException {
                return resultProducer.execute(canceler, statusCode, statusMessage, contentType, contentEncoding, inputStream);
            }

            @Override
            public boolean isApplicable(int statusCode, String contentType) {
                return applicable.isApplicable((Object)contentType);
            }
        });
        return this;
    }

    @Override
    public IObjectRequestExecutorBuilder<T> addResultProducer(final BiFunction<Integer, String, Boolean> applicable, final IResultProducer<T> resultProducer) {
        this.applicableResultProducers.add(new IApplicableResultProducer<T>(){

            @Override
            public T execute(ICanceler canceler, int statusCode, String statusMessage, String contentType, String contentEncoding, InputStream inputStream) throws IOException, InterruptedException {
                return resultProducer.execute(canceler, statusCode, statusMessage, contentType, contentEncoding, inputStream);
            }

            @Override
            public boolean isApplicable(int statusCode, String contentType) {
                return (Boolean)applicable.apply(statusCode, contentType);
            }
        });
        return this;
    }
}

