/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.image.encoder;

import com.sun.media.jai.codec.ImageEncoder;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import net.anwiba.commons.image.encoder.IEncoder;
import net.anwiba.commons.lang.stream.Streams;

public abstract class AbstractEncoder
implements IEncoder {
    private final String mimetype;

    public AbstractEncoder(String mimetype) {
        this.mimetype = mimetype;
    }

    @Override
    public void encode(BufferedImage image, OutputStream out) throws IOException {
        ImageWriter writer = this.getWriter(out);
        if (writer != null) {
            writer.write(image);
            return;
        }
        ImageEncoder encoder = this.getEncoder(image, out);
        if (encoder != null) {
            encoder.encode((RenderedImage)image);
            return;
        }
        throw new IOException();
    }

    private ImageWriter getWriter(OutputStream out) throws IOException {
        return (ImageWriter)Streams.create(IOException.class, ImageIO.getImageWritersByMIMEType(this.mimetype)).first().consume(w -> w.setOutput(ImageIO.createImageOutputStream(out))).get();
    }

    protected abstract ImageEncoder getEncoder(RenderedImage var1, OutputStream var2);
}

