/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.image.graphic;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import net.anwiba.commons.image.graphic.AbstractGraphics;
import net.anwiba.commons.image.graphic.IClosableGraphics;
import net.anwiba.commons.lang.optional.If;
import net.anwiba.commons.lang.optional.Optional;

class ClosableGraphics
extends AbstractGraphics
implements IClosableGraphics {
    private final Object antiAliasing;
    private final Object alphaInterpolation;
    private final Object colorRendering;
    private final Object dithering;
    private final Object fractionalmetrics;
    private final Object interpolation;
    private final Object rendering;
    private final Object strokeControl;
    private final Object textAntialiasing;
    private final Object textLcdContrast;
    private final Graphics2D graphics;
    private final boolean dispose;

    ClosableGraphics(boolean dispose, Graphics2D graphics, Object antiAliasing, Object alphaInterpolation, Object colorRendering, Object dithering, Object fractionalmetrics, Object interpolation, Object rendering, Object strokeControl, Object textAntialiasing, Object textLcdContrast) {
        super(graphics);
        this.dispose = dispose;
        this.graphics = graphics;
        this.antiAliasing = antiAliasing;
        this.alphaInterpolation = alphaInterpolation;
        this.colorRendering = colorRendering;
        this.dithering = dithering;
        this.fractionalmetrics = fractionalmetrics;
        this.interpolation = interpolation;
        this.rendering = rendering;
        this.strokeControl = strokeControl;
        this.textAntialiasing = textAntialiasing;
        this.textLcdContrast = textLcdContrast;
    }

    @Override
    public void close() throws RuntimeException {
        Optional.of((Object)this.antiAliasing).consume(value -> this.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, value));
        Optional.of((Object)this.textAntialiasing).consume(value -> this.graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, value));
        Optional.of((Object)this.alphaInterpolation).consume(value -> this.graphics.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, value)).or(() -> this.graphics.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_DEFAULT));
        Optional.of((Object)this.colorRendering).consume(value -> this.graphics.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, value)).or(() -> this.graphics.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_DEFAULT));
        Optional.of((Object)this.interpolation).consume(value -> this.graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, value)).or(() -> this.graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR));
        Optional.of((Object)this.dithering).consume(value -> this.graphics.setRenderingHint(RenderingHints.KEY_DITHERING, value)).or(() -> this.graphics.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DEFAULT));
        Optional.of((Object)this.fractionalmetrics).consume(value -> this.graphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, value)).or(() -> this.graphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_DEFAULT));
        Optional.of((Object)this.textLcdContrast).consume(value -> this.graphics.setRenderingHint(RenderingHints.KEY_TEXT_LCD_CONTRAST, value));
        Optional.of((Object)this.strokeControl).consume(value -> this.graphics.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, value)).or(() -> this.graphics.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT));
        Optional.of((Object)this.rendering).consume(value -> this.graphics.setRenderingHint(RenderingHints.KEY_RENDERING, value)).or(() -> this.graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_DEFAULT));
        If.isTrue((boolean)this.dispose).excecute(() -> this.graphics.dispose());
    }
}

