/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.jdbc.name;

import net.anwiba.commons.jdbc.name.IDatabaseNamesConstants;
import net.anwiba.commons.jdbc.name.IDatabaseNamesConverter;
import net.anwiba.commons.lang.functional.IConverter;
import net.anwiba.commons.utilities.name.INamesConverter;
import net.anwiba.commons.utilities.name.LowerCaseNameConverter;
import net.anwiba.commons.utilities.name.NameConverter;
import net.anwiba.commons.utilities.name.UniqueNameBuilder;
import net.anwiba.commons.utilities.name.UpperCaseNameConverter;

public class DatabaseNamesConverter
implements IDatabaseNamesConverter {
    private final UniqueNameBuilder nameBuilder;

    public static INamesConverter createLowerCaseFactory(int maximumLength) {
        return new DatabaseNamesConverter((IConverter<String, String, RuntimeException>)new LowerCaseNameConverter(), maximumLength);
    }

    public static INamesConverter createUpperCaseFactory(int maximumLength) {
        return new DatabaseNamesConverter((IConverter<String, String, RuntimeException>)new UpperCaseNameConverter(), maximumLength);
    }

    public static INamesConverter create(int maximumLength) {
        return new DatabaseNamesConverter((IConverter<String, String, RuntimeException>)new NameConverter(), maximumLength);
    }

    private DatabaseNamesConverter(IConverter<String, String, RuntimeException> nameConverter, int maximumLength) {
        this.nameBuilder = new UniqueNameBuilder(maximumLength, nameConverter, IDatabaseNamesConstants.RESERVED_NAMES);
    }

    public String convert(String columnName) {
        if (columnName == null) {
            return null;
        }
        return this.nameBuilder.build(columnName);
    }
}

