/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.mail;

import java.util.ArrayList;
import java.util.List;
import net.anwiba.commons.mail.Attachment;
import net.anwiba.commons.mail.IMail;
import net.anwiba.commons.mail.Mail;

public final class MailBuilder {
    private String sender;
    private String replayRecipient;
    private String recipient;
    private String subject;
    private String content;
    private final List<Attachment> attachments = new ArrayList<Attachment>();

    public MailBuilder setSender(String sender) {
        this.sender = sender;
        return this;
    }

    public IMail build() {
        return new Mail(this.sender, this.replayRecipient, this.recipient, this.subject, this.content, this.attachments);
    }

    public MailBuilder setRecipient(String recipient) {
        this.recipient = recipient;
        return this;
    }

    public MailBuilder setSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public MailBuilder setContent(String content) {
        this.content = content;
        return this;
    }

    public MailBuilder addAttachment(String content, String filename, String mimeTpye) {
        this.attachments.add(new Attachment(content, filename, mimeTpye));
        return this;
    }

    public MailBuilder setReplayRecipient(String replayRecipient) {
        this.replayRecipient = replayRecipient;
        return this;
    }
}

