/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.mail;

import java.util.Date;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import net.anwiba.commons.lang.exception.CreationException;
import net.anwiba.commons.mail.Attachment;
import net.anwiba.commons.mail.IMail;

public final class MimeMessageFactory {
    private final Session session;

    public MimeMessageFactory(Session session) {
        this.session = session;
    }

    public MimeMessage create(IMail mail) throws CreationException {
        try {
            MimeMessage mimeMessage = new MimeMessage(this.session);
            mimeMessage.setFrom((Address)new InternetAddress(mail.getSender()));
            if (mail.getReplayRecipient() != null) {
                mimeMessage.setReplyTo(new Address[]{new InternetAddress(mail.getReplayRecipient())});
            }
            mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)mail.getRecipient(), (boolean)false));
            mimeMessage.setSubject(mail.getSubject());
            MimeMultipart multiPart = new MimeMultipart();
            MimeBodyPart messageBody = new MimeBodyPart();
            messageBody.setText(mail.getContent());
            multiPart.addBodyPart((BodyPart)messageBody);
            for (Attachment attachment : mail.getAttachments()) {
                MimeBodyPart attachmentPart = new MimeBodyPart();
                attachmentPart.setFileName(attachment.getFilename());
                attachmentPart.setContent((Object)(attachment.getContent() == null ? "--empty--" : attachment.getContent()), attachment.getMimeTpye());
                multiPart.addBodyPart((BodyPart)attachmentPart);
            }
            mimeMessage.setContent((Multipart)multiPart);
            mimeMessage.setSentDate(new Date());
            return mimeMessage;
        }
        catch (MessagingException exception) {
            throw new CreationException(exception.getMessage(), (Throwable)exception);
        }
    }
}

