/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.reference;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.reference.FileResourceReference;
import net.anwiba.commons.reference.IResourceReference;
import net.anwiba.commons.reference.IResourceReferenceVisitor;
import net.anwiba.commons.reference.MemoryResourceReference;
import net.anwiba.commons.reference.PathResourceReference;
import net.anwiba.commons.reference.UriResourceReference;
import net.anwiba.commons.reference.UrlResourceReference;
import net.anwiba.commons.reference.utilities.FileUtilities;
import net.anwiba.commons.reference.utilities.UriToUrlConverter;
import net.anwiba.commons.reference.utilities.UriUtilities;
import net.anwiba.commons.reference.utilities.UrlToUriConverter;

public class ResourceReferenceUtilities {
    static ILogger logger = Logging.getLogger((String)ResourceReferenceUtilities.class.getName());

    public static File getFile(IResourceReference resourceReference) throws URISyntaxException {
        if (resourceReference == null) {
            throw new IllegalArgumentException();
        }
        final UrlToUriConverter urlToUriConverter = new UrlToUriConverter();
        return resourceReference.accept(new IResourceReferenceVisitor<File, URISyntaxException>(){

            @Override
            public File visitUrlResource(UrlResourceReference urlResourceReference) throws URISyntaxException {
                return new File(urlToUriConverter.convert(urlResourceReference.getUrl()));
            }

            @Override
            public File visitUriResource(UriResourceReference uriResourceReference) {
                return new File(uriResourceReference.getUri());
            }

            @Override
            public File visitFileResource(FileResourceReference fileResourceReference) {
                return fileResourceReference.getFile();
            }

            @Override
            public File visitMemoryResource(MemoryResourceReference memoryResourceReference) {
                throw new UnsupportedOperationException();
            }

            @Override
            public File visitPathResource(PathResourceReference pathResourceReference) throws URISyntaxException {
                return pathResourceReference.getPath().toFile();
            }
        });
    }

    public static URL getUrl(IResourceReference resourceReference) throws MalformedURLException {
        if (resourceReference == null) {
            throw new IllegalArgumentException();
        }
        final UriToUrlConverter uriToUrlConverter = new UriToUrlConverter();
        return resourceReference.accept(new IResourceReferenceVisitor<URL, MalformedURLException>(){

            @Override
            public URL visitUrlResource(UrlResourceReference urlResourceReference) {
                return urlResourceReference.getUrl();
            }

            @Override
            public URL visitUriResource(UriResourceReference uriResourceReference) throws MalformedURLException {
                return uriToUrlConverter.convert(uriResourceReference.getUri());
            }

            @Override
            public URL visitFileResource(FileResourceReference fileResourceReference) throws MalformedURLException {
                return uriToUrlConverter.convert(fileResourceReference.getFile().toURI());
            }

            @Override
            public URL visitMemoryResource(MemoryResourceReference memoryResourceReference) throws MalformedURLException {
                return new URL(memoryResourceReference.toString());
            }

            @Override
            public URL visitPathResource(PathResourceReference pathResourceReference) throws MalformedURLException {
                return uriToUrlConverter.convert(pathResourceReference.getPath().toUri());
            }
        });
    }

    public static URI getUri(IResourceReference resourceReference) throws URISyntaxException {
        if (resourceReference == null) {
            throw new IllegalArgumentException();
        }
        final UrlToUriConverter urlToUriConverter = new UrlToUriConverter();
        return resourceReference.accept(new IResourceReferenceVisitor<URI, URISyntaxException>(){

            @Override
            public URI visitUrlResource(UrlResourceReference urlResourceReference) throws URISyntaxException {
                return urlToUriConverter.convert(urlResourceReference.getUrl());
            }

            @Override
            public URI visitUriResource(UriResourceReference uriResourceReference) {
                return uriResourceReference.getUri();
            }

            @Override
            public URI visitFileResource(FileResourceReference fileResourceReference) {
                return fileResourceReference.getFile().toURI();
            }

            @Override
            public URI visitMemoryResource(MemoryResourceReference memoryResourceReference) throws URISyntaxException {
                return new URI(memoryResourceReference.toString());
            }

            @Override
            public URI visitPathResource(PathResourceReference pathResourceReference) throws URISyntaxException {
                return pathResourceReference.getPath().toUri();
            }
        });
    }

    public static String getExtension(IResourceReference resourceReference) {
        if (resourceReference == null) {
            throw new IllegalArgumentException();
        }
        return resourceReference.accept(new IResourceReferenceVisitor<String, RuntimeException>(){

            @Override
            public String visitFileResource(FileResourceReference fileResourceReference) throws RuntimeException {
                return FileUtilities.getExtension(fileResourceReference.getFile());
            }

            @Override
            public String visitUrlResource(UrlResourceReference urlResourceReference) throws RuntimeException {
                String path = urlResourceReference.getUrl().getPath();
                if (path == null) {
                    return null;
                }
                return FileUtilities.getExtension(new File(path));
            }

            @Override
            public String visitUriResource(UriResourceReference uriResourceReference) throws RuntimeException {
                String path = uriResourceReference.getUri().getPath();
                if (path == null) {
                    return null;
                }
                return FileUtilities.getExtension(new File(path));
            }

            @Override
            public String visitMemoryResource(MemoryResourceReference memoryResourceReference) throws RuntimeException {
                String mimeType;
                block3: {
                    try {
                        mimeType = memoryResourceReference.getMimeType();
                        if (mimeType != null) break block3;
                        return null;
                    }
                    catch (MimeTypeParseException mimeTypeParseException) {
                        return null;
                    }
                }
                return new MimeType(mimeType).getSubType();
            }

            @Override
            public String visitPathResource(PathResourceReference pathResourceReference) throws RuntimeException {
                return FileUtilities.getExtension(pathResourceReference.getPath().toFile());
            }
        });
    }

    public static boolean hasLocation(IResourceReference resourceReference) {
        if (resourceReference == null) {
            return false;
        }
        return resourceReference.accept(new IResourceReferenceVisitor<Boolean, RuntimeException>(){

            @Override
            public Boolean visitUrlResource(UrlResourceReference urlResourceReference) {
                return Boolean.TRUE;
            }

            @Override
            public Boolean visitUriResource(UriResourceReference uriResourceReference) {
                return Boolean.TRUE;
            }

            @Override
            public Boolean visitFileResource(FileResourceReference fileResourceReference) {
                return Boolean.TRUE;
            }

            @Override
            public Boolean visitMemoryResource(MemoryResourceReference memoryResourceReference) {
                return Boolean.FALSE;
            }

            @Override
            public Boolean visitPathResource(PathResourceReference pathResourceReference) throws RuntimeException {
                return Boolean.TRUE;
            }
        });
    }

    public static boolean isFileSystemResource(IResourceReference resourceReference) {
        if (resourceReference == null) {
            return false;
        }
        final UrlToUriConverter urlToUriConverter = new UrlToUriConverter();
        return resourceReference.accept(new IResourceReferenceVisitor<Boolean, RuntimeException>(){

            @Override
            public Boolean visitUriResource(UriResourceReference uriResourceReference) throws RuntimeException {
                return UriUtilities.isFileUri(uriResourceReference.getUri());
            }

            @Override
            public Boolean visitUrlResource(UrlResourceReference urlResourceReference) {
                try {
                    URI uri = urlToUriConverter.convert(urlResourceReference.getUrl());
                    return UriUtilities.isFileUri(uri);
                }
                catch (URISyntaxException exception) {
                    logger.log(ILevel.WARNING, exception.getLocalizedMessage());
                    return Boolean.FALSE;
                }
            }

            @Override
            public Boolean visitFileResource(FileResourceReference fileResourceReference) {
                return Boolean.TRUE;
            }

            @Override
            public Boolean visitMemoryResource(MemoryResourceReference memoryResourceReference) {
                return Boolean.FALSE;
            }

            @Override
            public Boolean visitPathResource(PathResourceReference pathResourceReference) throws RuntimeException {
                return Boolean.TRUE;
            }
        });
    }

    public static String toString(IResourceReference resourceReference) {
        if (resourceReference == null) {
            throw new IllegalArgumentException();
        }
        return resourceReference.accept(new IResourceReferenceVisitor<String, RuntimeException>(){

            @Override
            public String visitFileResource(FileResourceReference fileResourceReference) throws RuntimeException {
                return fileResourceReference.getFile().toString();
            }

            @Override
            public String visitUrlResource(UrlResourceReference urlResourceReference) throws RuntimeException {
                return urlResourceReference.getUrl().toString();
            }

            @Override
            public String visitUriResource(UriResourceReference uriResourceReference) throws RuntimeException {
                return uriResourceReference.getUri().toString();
            }

            @Override
            public String visitMemoryResource(MemoryResourceReference memoryResourceReference) throws RuntimeException {
                return memoryResourceReference.toString();
            }

            @Override
            public String visitPathResource(PathResourceReference pathResourceReference) throws RuntimeException {
                return pathResourceReference.getPath().toString();
            }
        });
    }
}

