/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.version;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import net.anwiba.commons.lang.exception.UnreachableCodeReachedException;
import net.anwiba.commons.version.IVersion;
import net.anwiba.commons.version.ProductState;
import net.anwiba.commons.version.ReleaseState;
import net.anwiba.commons.version.Version;
import net.anwiba.commons.version.VersionBuilder;

public class VersionUtilities {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IVersion getVersion(URL resource) {
        if (resource == null) {
            return Version.DUMMY;
        }
        Properties properties = new Properties();
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try {
                InputStream inputstream = resource.openStream();
                try {
                    Version version;
                    block17: {
                        InputStreamReader reader = new InputStreamReader(inputstream, "UTF-8");
                        try {
                            properties.load(reader);
                            int major = VersionUtilities.getIntProperty(properties, "version.mayor");
                            int minor = VersionUtilities.getIntProperty(properties, "version.minor");
                            int step = VersionUtilities.getIntProperty(properties, "version.step");
                            ReleaseState releaseState = VersionUtilities.getReleaseState(properties);
                            ProductState productState = VersionUtilities.getProductState(properties);
                            int buildCount = VersionUtilities.getIntProperty(properties, "build.count");
                            Date date = VersionUtilities.getDate(properties);
                            version = new Version(major, minor, releaseState, step, productState, date, buildCount);
                            return version;
                        }
                        finally {
                            if (reader == null) break block17;
                            reader.close();
                        }
                    }
                    if (inputstream != null) {
                        inputstream.close();
                    }
                    return version;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (inputstream == null) throw throwable;
                    inputstream.close();
                    throw throwable;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (IOException iOException) {
            return Version.DUMMY;
        }
    }

    private static Date getDate(Properties properties) {
        String property = properties.getProperty("build.date");
        if (property == null) {
            return Version.defaultDate;
        }
        try {
            return new SimpleDateFormat("yyyy.MM.dd HH:mm").parse(property);
        }
        catch (ParseException parseException) {
            return Version.defaultDate;
        }
    }

    private static ProductState getProductState(Properties properties) {
        String property = properties.getProperty("version.state.product");
        if (property == null) {
            return ProductState.EXPERIMENTAL;
        }
        try {
            return ProductState.valueOf(property);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return ProductState.EXPERIMENTAL;
        }
    }

    private static ReleaseState getReleaseState(Properties properties) {
        String property = properties.getProperty("version.state.release");
        if (property == null) {
            return ReleaseState.RELEASE;
        }
        try {
            return ReleaseState.valueOf(property);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return ReleaseState.RELEASE;
        }
    }

    private static int getIntProperty(Properties properties, String key) {
        String property = properties.getProperty(key);
        if (property == null) {
            return 0;
        }
        return Integer.parseInt(property);
    }

    public static IVersion valueOf(String string) {
        return new VersionParser().parse(string);
    }

    public static String getText(IVersion version) {
        String string = String.valueOf(version.getMajor());
        string = String.valueOf(string) + ".";
        string = String.valueOf(string) + String.valueOf(version.getMinor());
        ReleaseState releaseState = version.getReleaseState();
        string = releaseState != ReleaseState.RELEASE ? String.valueOf(string) + String.valueOf(releaseState.getAcronym()) : String.valueOf(string) + ".";
        string = String.valueOf(string) + String.valueOf(version.getStep());
        ProductState productState = version.getProductState();
        if (productState != ProductState.STABLE) {
            string = String.valueOf(string) + " ";
            string = String.valueOf(string) + String.valueOf(productState.getAcronym());
        }
        return string;
    }

    public static String getTextLong(IVersion version) {
        String string = VersionUtilities.getText(version);
        string = String.valueOf(string) + " ";
        string = String.valueOf(string) + version.getBuildCount();
        string = String.valueOf(string) + " ";
        string = String.valueOf(string) + new SimpleDateFormat("dd.MM.yyyy HH:mm").format(version.getDate());
        return string;
    }

    public static enum ParseState {
        UNDEFIND,
        MAJOR,
        MINOR,
        RELEASESTATE,
        STEP,
        PRODUCTSTATE,
        YEAR,
        MONTH,
        DAY,
        HOUR,
        MIN,
        COUNT;

    }

    public static class VersionParser {
        public IVersion parse(String string) {
            if (string == null) {
                return null;
            }
            boolean lastCharaterWasWhiteSpace = false;
            ParseState state = ParseState.UNDEFIND;
            StringBuilder builder = new StringBuilder();
            VersionBuilder versionBuilder = new VersionBuilder();
            char[] cArray = string.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                block12: {
                    ParseState tmpState;
                    char c;
                    block11: {
                        c = cArray[n2];
                        tmpState = state;
                        if (c == '.') {
                            state = this.point(state, builder, versionBuilder);
                            lastCharaterWasWhiteSpace = false;
                        }
                        if (c == ':') {
                            state = this.colon(state, builder, versionBuilder);
                            lastCharaterWasWhiteSpace = false;
                        }
                        if (!Character.isWhitespace(c) && c != '-') break block11;
                        if (lastCharaterWasWhiteSpace) break block12;
                        state = this.checkWhitespace(state, builder, versionBuilder);
                        lastCharaterWasWhiteSpace = true;
                    }
                    if (Character.isDigit(c)) {
                        state = this.digit(state, builder, versionBuilder);
                        lastCharaterWasWhiteSpace = false;
                    }
                    if (Character.isLetter(c)) {
                        state = this.letter(state, builder, versionBuilder);
                        lastCharaterWasWhiteSpace = false;
                    }
                    if (!state.equals((Object)tmpState)) {
                        builder = new StringBuilder();
                    }
                    if (c != '.' && c != ':' && !Character.isWhitespace(c)) {
                        builder.append(c);
                    }
                }
                ++n2;
            }
            state = this.resolve(state, builder, versionBuilder);
            return versionBuilder.build();
        }

        private ParseState resolve(ParseState state, StringBuilder builder, VersionBuilder versionBuilder) {
            switch (state) {
                case UNDEFIND: {
                    return state;
                }
                case MAJOR: {
                    versionBuilder.setMajor(builder.toString());
                    return state;
                }
                case MINOR: {
                    versionBuilder.setMinor(builder.toString());
                    return state;
                }
                case RELEASESTATE: {
                    versionBuilder.setReleaseState(builder.toString());
                    return state;
                }
                case STEP: {
                    versionBuilder.setStep(builder.toString());
                    return state;
                }
                case PRODUCTSTATE: {
                    versionBuilder.setProductState(builder.toString());
                    return state;
                }
                case YEAR: {
                    versionBuilder.setYear(builder.toString());
                    return state;
                }
                case MONTH: {
                    versionBuilder.setMonth(builder.toString());
                    return state;
                }
                case DAY: {
                    versionBuilder.setDay(builder.toString());
                    return state;
                }
                case HOUR: {
                    versionBuilder.setHour(builder.toString());
                    return state;
                }
                case MIN: {
                    versionBuilder.setMinute(builder.toString());
                    return state;
                }
                case COUNT: {
                    versionBuilder.setCount(builder.toString());
                    return state;
                }
            }
            throw new UnreachableCodeReachedException();
        }

        private ParseState checkWhitespace(ParseState state, StringBuilder builder, VersionBuilder versionBuilder) {
            switch (state) {
                case UNDEFIND: {
                    return state;
                }
                case MAJOR: {
                    versionBuilder.setMajor(builder.toString());
                    return ParseState.RELEASESTATE;
                }
                case MINOR: {
                    versionBuilder.setMinor(builder.toString());
                    return ParseState.RELEASESTATE;
                }
                case RELEASESTATE: {
                    versionBuilder.setReleaseState(builder.toString());
                    return ParseState.STEP;
                }
                case STEP: {
                    versionBuilder.setStep(builder.toString());
                    return ParseState.PRODUCTSTATE;
                }
                case PRODUCTSTATE: {
                    versionBuilder.setProductState(builder.toString());
                    return ParseState.YEAR;
                }
                case YEAR: {
                    versionBuilder.setYear(builder.toString());
                    return ParseState.HOUR;
                }
                case MONTH: {
                    versionBuilder.setMonth(builder.toString());
                    return ParseState.HOUR;
                }
                case DAY: {
                    versionBuilder.setDay(builder.toString());
                    return ParseState.HOUR;
                }
                case HOUR: {
                    versionBuilder.setHour(builder.toString());
                    return ParseState.COUNT;
                }
                case MIN: {
                    versionBuilder.setMinute(builder.toString());
                    return ParseState.COUNT;
                }
                case COUNT: {
                    throw new IllegalArgumentException();
                }
            }
            throw new UnreachableCodeReachedException();
        }

        private ParseState colon(ParseState state, StringBuilder builder, VersionBuilder versionBuilder) {
            switch (state) {
                case UNDEFIND: {
                    versionBuilder.setHour(builder.toString());
                    return ParseState.MIN;
                }
                case MAJOR: {
                    versionBuilder.setHour(builder.toString());
                    return ParseState.MIN;
                }
                case MINOR: {
                    versionBuilder.setHour(builder.toString());
                    return ParseState.MIN;
                }
                case RELEASESTATE: {
                    versionBuilder.setHour(builder.toString());
                    return ParseState.MIN;
                }
                case STEP: {
                    versionBuilder.setHour(builder.toString());
                    return ParseState.MIN;
                }
                case PRODUCTSTATE: {
                    versionBuilder.setHour(builder.toString());
                    return ParseState.MIN;
                }
                case YEAR: {
                    versionBuilder.setHour(builder.toString());
                    return ParseState.MIN;
                }
                case MONTH: {
                    versionBuilder.setHour(builder.toString());
                    return ParseState.MIN;
                }
                case DAY: {
                    versionBuilder.setHour(builder.toString());
                    return ParseState.MIN;
                }
                case HOUR: {
                    versionBuilder.setHour(builder.toString());
                    return ParseState.MIN;
                }
                case MIN: {
                    versionBuilder.setMinute(builder.toString());
                    return ParseState.MIN;
                }
                case COUNT: {
                    throw new IllegalArgumentException();
                }
            }
            throw new UnreachableCodeReachedException();
        }

        private ParseState point(ParseState state, StringBuilder builder, VersionBuilder versionBuilder) {
            switch (state) {
                case UNDEFIND: {
                    versionBuilder.setMajor(builder.toString());
                    return ParseState.MINOR;
                }
                case MAJOR: {
                    versionBuilder.setMajor(builder.toString());
                    return ParseState.MINOR;
                }
                case MINOR: {
                    versionBuilder.setMinor(builder.toString());
                    return ParseState.STEP;
                }
                case RELEASESTATE: {
                    throw new IllegalArgumentException();
                }
                case STEP: {
                    throw new IllegalArgumentException();
                }
                case PRODUCTSTATE: {
                    throw new IllegalArgumentException();
                }
                case YEAR: {
                    throw new IllegalArgumentException();
                }
                case MONTH: {
                    throw new IllegalArgumentException();
                }
                case DAY: {
                    throw new IllegalArgumentException();
                }
                case HOUR: {
                    throw new IllegalArgumentException();
                }
                case MIN: {
                    throw new IllegalArgumentException();
                }
                case COUNT: {
                    throw new IllegalArgumentException();
                }
            }
            throw new UnreachableCodeReachedException();
        }

        private ParseState letter(ParseState state, StringBuilder builder, VersionBuilder versionBuilder) {
            switch (state) {
                case UNDEFIND: {
                    return ParseState.RELEASESTATE;
                }
                case MAJOR: {
                    versionBuilder.setMajor(builder.toString());
                    return ParseState.RELEASESTATE;
                }
                case MINOR: {
                    versionBuilder.setMinor(builder.toString());
                    return ParseState.RELEASESTATE;
                }
                case RELEASESTATE: {
                    return state;
                }
                case STEP: {
                    versionBuilder.setStep(builder.toString());
                    return ParseState.PRODUCTSTATE;
                }
                case PRODUCTSTATE: {
                    return state;
                }
                case YEAR: {
                    throw new IllegalArgumentException();
                }
                case MONTH: {
                    throw new IllegalArgumentException();
                }
                case DAY: {
                    throw new IllegalArgumentException();
                }
                case HOUR: {
                    throw new IllegalArgumentException();
                }
                case MIN: {
                    throw new IllegalArgumentException();
                }
                case COUNT: {
                    throw new IllegalArgumentException();
                }
            }
            throw new UnreachableCodeReachedException();
        }

        private ParseState digit(ParseState state, StringBuilder builder, VersionBuilder versionBuilder) {
            switch (state) {
                case UNDEFIND: {
                    return ParseState.MAJOR;
                }
                case MAJOR: {
                    return state;
                }
                case MINOR: {
                    return state;
                }
                case RELEASESTATE: {
                    versionBuilder.setReleaseState(builder.toString());
                    return ParseState.STEP;
                }
                case STEP: {
                    return state;
                }
                case PRODUCTSTATE: {
                    versionBuilder.setProductState(builder.toString());
                    return ParseState.YEAR;
                }
                case YEAR: {
                    return state;
                }
                case MONTH: {
                    return state;
                }
                case DAY: {
                    return state;
                }
                case HOUR: {
                    return state;
                }
                case MIN: {
                    return state;
                }
                case COUNT: {
                    return state;
                }
            }
            throw new IllegalArgumentException();
        }
    }
}

