/*
 * #%L
 *
 * %%
 * Copyright (C) 2007 - 2018 Andreas W. Bartels
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 2.1 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-2.1.html>.
 * #L%
 */
package net.anwiba.commons.image;

import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.InputStream;

import net.anwiba.commons.image.awt.BufferedImageContainerFactory;
import net.anwiba.commons.image.imageio.ImageIoImageContainerFactory;
import net.anwiba.commons.image.jai.JAIImageContainerFactory;

public class ImageContainerFactory implements IImageContainerFactory {

  private static net.anwiba.commons.logging.ILogger logger = net.anwiba.commons.logging.Logging
      .getLogger(ImageContainerFactory.class);
  final JAIImageContainerFactory jaiImageContainerFactory = new JAIImageContainerFactory();
  final ImageIoImageContainerFactory imageIoImageContainerFactory;
  final BufferedImageContainerFactory bufferedImageContainerFactory;

  public ImageContainerFactory(final RenderingHints hints) {
    this.imageIoImageContainerFactory = new ImageIoImageContainerFactory(hints);
    this.bufferedImageContainerFactory = new BufferedImageContainerFactory(hints);
  }

  @Override
  public IImageContainer create(final InputStream inputStream) {
    //    try {
    //      return this.imageIoImageContainerFactory.create(inputStream);
    return this.jaiImageContainerFactory.create(inputStream);
    //    } catch (final IOException exception) {
    //      logger.log(ILevel.DEBUG, exception.getMessage(), exception);
    //      return create(ImageUtilities.create(100, 100));
    //    }
  }

  @Override
  public IImageContainer create(final BufferedImage image) {
    return this.bufferedImageContainerFactory.create(image);
    // return this.jaiImageContainerFactory.create(image);
  }
}
