/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.http;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import net.anwiba.commons.http.HttpRequestException;
import net.anwiba.commons.http.IHttpRequestExecutor;
import net.anwiba.commons.http.IHttpRequestExecutorFactory;
import net.anwiba.commons.http.IRequest;
import net.anwiba.commons.http.IResponse;
import net.anwiba.commons.http.RequestBuilder;
import net.anwiba.commons.lang.exception.CanceledException;
import net.anwiba.commons.lang.functional.IAcceptor;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.reference.IStreamConnector;
import net.anwiba.commons.thread.cancel.ICanceler;

public final class HttpClientConnector
implements IStreamConnector<URI> {
    private static ILogger logger = Logging.getLogger((String)HttpClientConnector.class.getName());
    private final IHttpRequestExecutorFactory httpRequestExcecutorFactory;

    public HttpClientConnector(IHttpRequestExecutorFactory httpRequestExcecutorFactory) {
        this.httpRequestExcecutorFactory = httpRequestExcecutorFactory;
    }

    private IHttpRequestExecutor requestExecutor() {
        return this.httpRequestExcecutorFactory.create();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean exist(URI uri) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                IResponse response = this.response(uri);
                try {
                    if (response.getStatusCode() >= 200 && response.getStatusCode() < 300) {
                        return true;
                    }
                    logger.log(ILevel.WARNING, "connect to '" + uri.toString() + "' faild " + response.getStatusCode() + " " + response.getStatusText());
                    if (logger.isLoggable(ILevel.DEBUG)) {
                        logger.log(ILevel.DEBUG, response.getBody());
                    }
                    return false;
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    if (response == null) return true;
                    response.close();
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (IOException | CanceledException exception) {
            logger.log(ILevel.WARNING, "connect to '" + uri.toString() + "' faild " + exception.getMessage());
            logger.log(ILevel.DEBUG, exception.getMessage(), exception);
            return false;
        }
    }

    private IResponse response(URI uri) throws CanceledException, IOException {
        IRequest request = this.request(uri);
        return this.requestExecutor().execute(ICanceler.DummyCanceler, request);
    }

    private IRequest request(URI uri) {
        return RequestBuilder.get(uri.toString()).build();
    }

    @Override
    public boolean canRead(URI uri) {
        Throwable throwable = null;
        Object var3_5 = null;
        InputStream inputStream = this.openInputStream(uri);
        if (inputStream != null) {
            inputStream.close();
        }
        try {
            return true;
        }
        catch (Throwable throwable2) {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                throw throwable2;
            }
            catch (Throwable throwable3) {
                try {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    logger.log(ILevel.DEBUG, exception.getMessage(), (Throwable)exception);
                    return false;
                }
            }
        }
    }

    @Override
    public boolean canWrite(URI uri) {
        return false;
    }

    @Override
    public InputStream openInputStream(URI uri) throws IOException {
        return this.openInputStream(uri, (IAcceptor<String>)((IAcceptor)s -> true));
    }

    @Override
    public InputStream openInputStream(URI uri, IAcceptor<String> contentTypeAcceptor) throws IOException {
        try {
            final IResponse response = this.response(uri);
            if (response.getStatusCode() >= 200 && response.getStatusCode() < 300) {
                if (!contentTypeAcceptor.accept((Object)response.getContentType())) {
                    throw HttpRequestException.create("Unexcepted mime type '" + response.getContentType() + "'", response);
                }
                return new FilterInputStream(response.getInputStream()){

                    @Override
                    public void close() throws IOException {
                        response.close();
                    }
                };
            }
            logger.log(ILevel.DEBUG, "connect to '" + uri.toString() + "' faild " + response.getStatusCode() + " " + response.getStatusText());
            if (logger.isLoggable(ILevel.DEBUG)) {
                logger.log(ILevel.DEBUG, response.getBody());
            }
            throw HttpRequestException.create(String.valueOf(response.getStatusCode()) + " - " + response.getStatusText(), response);
        }
        catch (IOException | CanceledException exception) {
            logger.log(ILevel.DEBUG, "connect to '" + uri.toString() + "' faild " + exception.getMessage());
            throw new IOException(exception);
        }
    }

    @Override
    public OutputStream openOutputStream(URI uri) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getContentLength(URI uri) throws IOException {
        IResponse response;
        block16: {
            long l;
            block17: {
                Throwable throwable = null;
                Object var3_4 = null;
                response = this.response(uri);
                try {
                    int statusCode = response.getStatusCode();
                    if (200 > statusCode || statusCode >= 300) break block16;
                    l = response.getContentLength();
                    if (response == null) break block17;
                }
                catch (Throwable throwable2) {
                    try {
                        if (response != null) {
                            response.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        try {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                        catch (IOException | CanceledException throwable4) {
                            return -1L;
                        }
                    }
                }
                response.close();
            }
            return l;
        }
        if (response != null) {
            response.close();
        }
        return -1L;
    }

    @Override
    public String getContentType(URI uri) throws IOException {
        IResponse response;
        block16: {
            String string;
            block17: {
                Throwable throwable = null;
                Object var3_4 = null;
                response = this.response(uri);
                try {
                    int statusCode = response.getStatusCode();
                    if (200 > statusCode || statusCode >= 300) break block16;
                    string = response.getContentType();
                    if (response == null) break block17;
                }
                catch (Throwable throwable2) {
                    try {
                        if (response != null) {
                            response.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        try {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                        catch (IOException | CanceledException throwable4) {
                            return null;
                        }
                    }
                }
                response.close();
            }
            return string;
        }
        if (response != null) {
            response.close();
        }
        return null;
    }
}

