/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.http;

import java.io.IOException;
import java.io.InputStream;
import net.anwiba.commons.http.HttpMethodType;
import net.anwiba.commons.http.IAuthentication;
import net.anwiba.commons.http.IRequest;
import net.anwiba.commons.lang.functional.IClosure;
import net.anwiba.commons.utilities.parameter.IParameters;

public final class Request
implements IRequest {
    private final HttpMethodType methodType;
    private final String urlString;
    private final IParameters parameters;
    private final IClosure<InputStream, IOException> inputStreamClosure;
    private final long contentLength;
    private final String encoding;
    private final String mimeType;
    private final String userAgent;
    private final IParameters properties;
    private final IAuthentication authentication;
    private final String host;
    private final int port;

    Request(HttpMethodType methodType, String host, int port, IAuthentication authentication, String urlString, IParameters parameters, IParameters properties, String userAgent, IClosure<InputStream, IOException> inputStreamClosure, long contentLength, String encoding, String mimeType) {
        this.methodType = methodType;
        this.host = host;
        this.port = port;
        this.urlString = urlString;
        this.authentication = authentication;
        this.parameters = parameters;
        this.properties = properties;
        this.userAgent = userAgent;
        this.inputStreamClosure = inputStreamClosure;
        this.contentLength = contentLength;
        this.encoding = encoding;
        this.mimeType = mimeType;
    }

    @Override
    public String getUriString() {
        return this.urlString;
    }

    @Override
    public IAuthentication getAuthentication() {
        return this.authentication;
    }

    @Override
    public HttpMethodType getMethodType() {
        return this.methodType;
    }

    @Override
    public IParameters getParameters() {
        return this.parameters;
    }

    @Override
    public long getContentLength() {
        return this.contentLength;
    }

    @Override
    public String getUserAgent() {
        return this.userAgent;
    }

    @Override
    public IClosure<InputStream, IOException> getContent() {
        return this.inputStreamClosure;
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public IParameters getProperties() {
        return this.properties;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }
}

