/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.image;

import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import net.anwiba.commons.image.IImageContainer;
import net.anwiba.commons.image.IImageContainerFactory;
import net.anwiba.commons.image.awt.BufferedImageContainerFactory;
import net.anwiba.commons.image.imageio.ImageIoImageContainerFactory;
import net.anwiba.commons.image.jai.JAIImageContainerFactory;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;

public class ImageContainerFactory
implements IImageContainerFactory {
    private static ILogger logger = Logging.getLogger(ImageContainerFactory.class);
    final JAIImageContainerFactory jaiImageContainerFactory = new JAIImageContainerFactory();
    final ImageIoImageContainerFactory imageIoImageContainerFactory;
    final BufferedImageContainerFactory bufferedImageContainerFactory;

    public ImageContainerFactory(RenderingHints hints) {
        this.imageIoImageContainerFactory = new ImageIoImageContainerFactory(hints);
        this.bufferedImageContainerFactory = new BufferedImageContainerFactory(hints);
    }

    @Override
    public IImageContainer create(InputStream inputStream) {
        return this.jaiImageContainerFactory.create(inputStream);
    }

    @Override
    public IImageContainer create(BufferedImage image) {
        return this.bufferedImageContainerFactory.create(image);
    }
}

