/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.image;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import net.anwiba.commons.image.codec.IImageCodecVisitor;
import net.anwiba.commons.image.codec.ImageCodec;

public class ImageUtilities {
    public static BufferedImage create(int width, int height) {
        return new BufferedImage(width, height, 2);
    }

    public static BufferedImage getEmptyImage(final Dimension size, ImageCodec imageCodec) {
        if (imageCodec == null) {
            return ImageUtilities.getTransparentImage(size);
        }
        IImageCodecVisitor<BufferedImage, RuntimeException> visitor = new IImageCodecVisitor<BufferedImage, RuntimeException>(){

            @Override
            public BufferedImage visitUnknown() {
                return ImageUtilities.getTransparentImage(size);
            }

            @Override
            public BufferedImage visitPng() {
                return ImageUtilities.getTransparentImage(size);
            }

            @Override
            public BufferedImage visitJpeg() {
                return ImageUtilities.getNonTransparentImage(size);
            }

            @Override
            public BufferedImage visitBmp() throws RuntimeException {
                return ImageUtilities.getNonTransparentImage(size);
            }

            @Override
            public BufferedImage visitTiff() throws RuntimeException {
                return ImageUtilities.getNonTransparentImage(size);
            }

            @Override
            public BufferedImage visitGif() throws RuntimeException {
                return ImageUtilities.getTransparentImage(size);
            }
        };
        return imageCodec.accept(visitor);
    }

    public static BufferedImage getTransparentImage(Dimension size) {
        return new BufferedImage(size.width, size.height, 2);
    }

    public static BufferedImage getNonTransparentImage(Dimension size) {
        Graphics graphic = null;
        try {
            BufferedImage image = new BufferedImage(size.width, size.height, 1);
            graphic = (Graphics2D)image.getGraphics();
            graphic.setColor(Color.WHITE);
            graphic.fillRect(0, 0, size.width, size.height);
            BufferedImage bufferedImage = image;
            return bufferedImage;
        }
        finally {
            if (graphic != null) {
                graphic.dispose();
            }
        }
    }
}

