/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.image.awt;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import net.anwiba.commons.image.IImageContainer;
import net.anwiba.commons.image.awt.BufferedImageMetadata;
import net.anwiba.commons.image.awt.BufferedImageMetadataFactory;
import net.anwiba.commons.image.awt.BufferedImageOperatorFactory;
import net.anwiba.commons.image.awt.IBufferedImageOperator;
import net.anwiba.commons.image.operation.IImageOperation;
import net.anwiba.commons.image.operation.ImageCropOperation;
import net.anwiba.commons.image.operation.ImageInvertOperation;
import net.anwiba.commons.image.operation.ImageMapBandsOperation;
import net.anwiba.commons.image.operation.ImageScaleOperation;
import net.anwiba.commons.image.operation.ImageToGrayScaleOperation;
import net.anwiba.commons.lang.collection.IMutableObjectList;
import net.anwiba.commons.lang.collection.IObjectList;
import net.anwiba.commons.lang.collection.ObjectList;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;

public class BufferedImageContainer
implements IImageContainer {
    private static ILogger logger = Logging.getLogger(BufferedImageContainer.class);
    private final BufferedImage image;
    private final IMutableObjectList<IImageOperation> operations = new ObjectList();
    private final BufferedImageMetadata metadata;
    private final RenderingHints hints;

    public BufferedImageContainer(RenderingHints hints, BufferedImageMetadata metadata, BufferedImage image, IObjectList<IImageOperation> operations) {
        this.hints = hints;
        this.image = image;
        this.metadata = metadata;
        this.operations.add(operations);
    }

    @Override
    public void dispose() {
    }

    @Override
    public int getWidth() {
        return (int)Math.ceil(this.metadata.getWidth());
    }

    @Override
    public int getHeight() {
        return (int)Math.ceil(this.metadata.getHeight());
    }

    @Override
    public int getNumberOfBands() {
        return this.metadata.getNumberOfBands();
    }

    @Override
    public int getColorSpaceType() {
        return this.metadata.getColorSpaceType();
    }

    @Override
    public IImageContainer crop(Rectangle rectangle) {
        return this.crop(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    @Override
    public IImageContainer crop(float x, float y, float width, float height) {
        ObjectList operations = new ObjectList(this.operations);
        ImageCropOperation operation = (ImageCropOperation)operations.stream().instanceOf(ImageCropOperation.class).first().get();
        Optional.of((Object)operation).consume(arg_0 -> BufferedImageContainer.lambda$0((IMutableObjectList)operations, x, y, width, height, arg_0)).or(() -> BufferedImageContainer.lambda$1((IMutableObjectList)operations, x, y, width, height));
        return new BufferedImageContainer(this.hints, new BufferedImageMetadata(this.metadata.getIndex(), width, height, this.metadata.getNumberOfComponents(), this.metadata.getNumberOfBands(), this.metadata.getColorSpaceType()), this.image, (IObjectList<IImageOperation>)operations);
    }

    @Override
    public IImageContainer fit(int width, int height) {
        float withFactor = this.factor(width, this.getWidth());
        float heightfactor = this.factor(height, this.getHeight());
        return this.scale(Math.max(withFactor, heightfactor));
    }

    private float factor(int numerator, int denominator) {
        return (float)numerator / (float)denominator;
    }

    @Override
    public IImageContainer scale(float widthFactor, float heightFactor) {
        ObjectList operations = new ObjectList(this.operations);
        ImageScaleOperation operation = (ImageScaleOperation)operations.stream().instanceOf(ImageScaleOperation.class).first().get();
        Optional.of((Object)operation).consume(arg_0 -> BufferedImageContainer.lambda$2((IMutableObjectList)operations, widthFactor, heightFactor, arg_0)).or(() -> BufferedImageContainer.lambda$3((IMutableObjectList)operations, widthFactor, heightFactor));
        return new BufferedImageContainer(this.hints, new BufferedImageMetadata(this.metadata.getIndex(), this.metadata.getWidth() * widthFactor, this.metadata.getHeight() * heightFactor, this.metadata.getNumberOfComponents(), this.metadata.getNumberOfBands(), this.metadata.getColorSpaceType()), this.image, (IObjectList<IImageOperation>)operations);
    }

    @Override
    public IImageContainer scale(float factor) {
        return this.scale(factor, factor);
    }

    @Override
    public IImageContainer invert() {
        ObjectList operations = new ObjectList(this.operations);
        ImageInvertOperation operation = (ImageInvertOperation)operations.stream().instanceOf(ImageInvertOperation.class).first().get();
        Optional.of((Object)operation).consume(arg_0 -> BufferedImageContainer.lambda$4((IMutableObjectList)operations, arg_0)).or(() -> BufferedImageContainer.lambda$5((IMutableObjectList)operations));
        return new BufferedImageContainer(this.hints, new BufferedImageMetadata(this.metadata.getIndex(), this.metadata.getWidth(), this.metadata.getHeight(), this.metadata.getNumberOfComponents(), this.metadata.getNumberOfBands(), this.metadata.getColorSpaceType()), this.image, (IObjectList<IImageOperation>)operations);
    }

    @Override
    public IImageContainer toGrayScale() {
        ObjectList operations = new ObjectList(this.operations);
        ImageToGrayScaleOperation operation = (ImageToGrayScaleOperation)operations.stream().instanceOf(ImageToGrayScaleOperation.class).first().get();
        Optional.of((Object)operation).or(() -> BufferedImageContainer.lambda$6((IMutableObjectList)operations));
        return new BufferedImageContainer(this.hints, new BufferedImageMetadata(this.metadata.getIndex(), this.metadata.getWidth(), this.metadata.getHeight(), 1, 1, 6), this.image, (IObjectList<IImageOperation>)operations);
    }

    @Override
    public IImageContainer mapBands(int[] bandMapping) {
        if (bandMapping == null || bandMapping.length == 0) {
            return this;
        }
        if (bandMapping.length < this.metadata.getNumberOfBands()) {
            throw new IllegalArgumentException();
        }
        ObjectList operations = new ObjectList(this.operations);
        ImageCropOperation operation = (ImageCropOperation)operations.stream().instanceOf(ImageCropOperation.class).first().get();
        Optional.of((Object)operation).consume(arg_0 -> BufferedImageContainer.lambda$7((IMutableObjectList)operations, arg_0));
        operations.add((Object[])new IImageOperation[]{new ImageMapBandsOperation(bandMapping)});
        return new BufferedImageContainer(this.hints, new BufferedImageMetadata(this.metadata.getIndex(), this.metadata.getWidth(), this.metadata.getHeight(), this.metadata.getNumberOfComponents(), this.metadata.getNumberOfBands(), this.metadata.getColorSpaceType()), this.image, (IObjectList<IImageOperation>)operations);
    }

    @Override
    public BufferedImage asBufferImage() {
        long size = (long)this.getWidth() * (long)this.getHeight();
        if (size >= Integer.MAX_VALUE) {
            logger.log(ILevel.WARNING, "image dimensions (width=" + this.getWidth() + " height=" + this.getHeight() + ") are too large");
            return null;
        }
        IBufferedImageOperator bufferedImageOperator = new BufferedImageOperatorFactory().create(new BufferedImageMetadataFactory().create(this.image), (IObjectList<IImageOperation>)this.operations, this.hints);
        return bufferedImageOperator.execute(this.image);
    }

    @Override
    public int getNumberOfComponents() {
        return this.metadata.getNumberOfComponents();
    }

    private static /* synthetic */ void lambda$0(IMutableObjectList iMutableObjectList, float f, float f2, float f3, float f4, ImageCropOperation o) throws RuntimeException {
        iMutableObjectList.remove((Object[])new IImageOperation[]{o});
        iMutableObjectList.add((Object[])new IImageOperation[]{new ImageCropOperation(o.getX() + f, o.getY() + f2, f3, f4)});
    }

    private static /* synthetic */ void lambda$1(IMutableObjectList iMutableObjectList, float f, float f2, float f3, float f4) throws RuntimeException {
        iMutableObjectList.add((Object[])new IImageOperation[]{new ImageCropOperation(f, f2, f3, f4)});
    }

    private static /* synthetic */ void lambda$2(IMutableObjectList iMutableObjectList, float f, float f2, ImageScaleOperation o) throws RuntimeException {
        iMutableObjectList.remove((Object[])new IImageOperation[]{o});
        iMutableObjectList.add((Object[])new IImageOperation[]{new ImageScaleOperation(o.getWidthFactor() * f, o.getHeightFactor() * f2)});
    }

    private static /* synthetic */ void lambda$3(IMutableObjectList iMutableObjectList, float f, float f2) throws RuntimeException {
        iMutableObjectList.add((Object[])new IImageOperation[]{new ImageScaleOperation(f, f2)});
    }

    private static /* synthetic */ void lambda$4(IMutableObjectList iMutableObjectList, ImageInvertOperation o) throws RuntimeException {
        iMutableObjectList.remove((Object[])new IImageOperation[]{o});
    }

    private static /* synthetic */ void lambda$5(IMutableObjectList iMutableObjectList) throws RuntimeException {
        iMutableObjectList.add((Object[])new IImageOperation[]{new ImageInvertOperation()});
    }

    private static /* synthetic */ void lambda$6(IMutableObjectList iMutableObjectList) throws RuntimeException {
        iMutableObjectList.add((Object[])new IImageOperation[]{new ImageToGrayScaleOperation()});
    }

    private static /* synthetic */ void lambda$7(IMutableObjectList iMutableObjectList, ImageCropOperation o) throws RuntimeException {
        iMutableObjectList.remove((Object[])new IImageOperation[]{o});
    }
}

