/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.image.awt;

import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorConvertOp;
import java.awt.image.LookupOp;
import java.awt.image.LookupTable;
import net.anwiba.commons.image.awt.BufferedImageMetadata;
import net.anwiba.commons.image.awt.IBufferedImageOperator;
import net.anwiba.commons.image.operation.IImageOperation;
import net.anwiba.commons.image.operation.ImageCropOperation;
import net.anwiba.commons.image.operation.ImageInvertOperation;
import net.anwiba.commons.image.operation.ImageMapBandsOperation;
import net.anwiba.commons.image.operation.ImageScaleOperation;
import net.anwiba.commons.image.operation.ImageToGrayScaleOperation;
import net.anwiba.commons.lang.collection.IObjectList;

public class BufferedImageOperatorFactory {
    IBufferedImageOperator create(BufferedImageMetadata metadata, IImageOperation operation, RenderingHints hints) {
        if (operation instanceof ImageScaleOperation) {
            ImageScaleOperation o = (ImageScaleOperation)operation;
            return new BufferedImageOpOperator(new AffineTransformOp(AffineTransform.getScaleInstance(o.getWidthFactor(), o.getHeightFactor()), hints));
        }
        if (operation instanceof ImageCropOperation) {
            final ImageCropOperation o = (ImageCropOperation)operation;
            return new IBufferedImageOperator(){

                @Override
                public BufferedImage execute(BufferedImage source) {
                    return source.getSubimage(Math.round(o.getX()), Math.round(o.getX()), Math.round(o.getWidth()), Math.round(o.getHeight()));
                }
            };
        }
        if (operation instanceof ImageMapBandsOperation) {
            final ImageMapBandsOperation o = (ImageMapBandsOperation)operation;
            LookupTable lookupTable = new LookupTable(0, metadata.getNumberOfBands()){

                @Override
                public int[] lookupPixel(int[] src, int[] dest) {
                    int[] bandMapping = o.getBandMapping();
                    int i = 0;
                    while (i < dest.length) {
                        dest[i] = src[bandMapping[i]];
                        ++i;
                    }
                    return dest;
                }
            };
            return new BufferedImageOpOperator(new LookupOp(lookupTable, hints));
        }
        if (operation instanceof ImageInvertOperation) {
            LookupTable lookupTable = new LookupTable(0, metadata.getNumberOfBands()){

                @Override
                public int[] lookupPixel(int[] src, int[] dest) {
                    int i = 0;
                    while (i < dest.length) {
                        dest[i] = 255 - src[i];
                        ++i;
                    }
                    return dest;
                }
            };
            return new BufferedImageOpOperator(new LookupOp(lookupTable, hints));
        }
        if (operation instanceof ImageToGrayScaleOperation) {
            return new BufferedImageOpOperator(new ColorConvertOp(ColorSpace.getInstance(1003), hints));
        }
        return new IBufferedImageOperator(){

            @Override
            public BufferedImage execute(BufferedImage source) {
                return source;
            }
        };
    }

    IBufferedImageOperator create(BufferedImageMetadata metadata, IObjectList<IImageOperation> operations, RenderingHints hints) {
        IObjectList collection = operations.stream().convert(o -> this.create(metadata, (IImageOperation)o, hints)).asObjectList();
        return new AggregatedBufferedImageOperator((IObjectList<IBufferedImageOperator>)collection);
    }

    public static final class AggregatedBufferedImageOperator
    implements IBufferedImageOperator {
        private final IObjectList<IBufferedImageOperator> collection;

        public AggregatedBufferedImageOperator(IObjectList<IBufferedImageOperator> collection) {
            this.collection = collection;
        }

        @Override
        public BufferedImage execute(BufferedImage source) {
            return (BufferedImage)this.collection.stream().aggregate((Object)source, (s, o) -> o.execute((BufferedImage)s)).get();
        }
    }

    static final class BufferedImageOpOperator
    implements IBufferedImageOperator {
        private final BufferedImageOp bufferedImageOp;

        public BufferedImageOpOperator(BufferedImageOp bufferedImageOp) {
            this.bufferedImageOp = bufferedImageOp;
        }

        @Override
        public BufferedImage execute(BufferedImage source) {
            return this.bufferedImageOp.filter(source, null);
        }
    }
}

