/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.image.imageio;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import net.anwiba.commons.image.IImageContainer;
import net.anwiba.commons.image.awt.BufferedImageContainerFactory;
import net.anwiba.commons.image.imageio.ImageIoImageMetadata;
import net.anwiba.commons.image.operation.IImageOperation;
import net.anwiba.commons.image.operation.ImageCropOperation;
import net.anwiba.commons.image.operation.ImageInvertOperation;
import net.anwiba.commons.image.operation.ImageMapBandsOperation;
import net.anwiba.commons.image.operation.ImageScaleOperation;
import net.anwiba.commons.image.operation.ImageToGrayScaleOperation;
import net.anwiba.commons.lang.collection.IMutableObjectList;
import net.anwiba.commons.lang.collection.IObjectList;
import net.anwiba.commons.lang.collection.ObjectList;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;

public class ImageIoImageContainer
implements IImageContainer {
    private static ILogger logger = Logging.getLogger(ImageIoImageContainer.class);
    private final ImageIoImageMetadata metadata;
    private final ImageReader imageReader;
    private final IMutableObjectList<IImageOperation> operations = new ObjectList();
    private final RenderingHints hints;
    private final BufferedImageContainerFactory bufferedImageContainerFactory;

    public ImageIoImageContainer(RenderingHints hints, ImageIoImageMetadata metadata, ImageReader imageReader) {
        this(hints, metadata, imageReader, (IObjectList<IImageOperation>)new ObjectList());
    }

    private ImageIoImageContainer(RenderingHints hints, ImageIoImageMetadata metadata, ImageReader imageReader, IObjectList<IImageOperation> operations) {
        this.bufferedImageContainerFactory = new BufferedImageContainerFactory(hints);
        this.hints = hints;
        this.metadata = metadata;
        this.imageReader = imageReader;
        this.operations.add(operations);
    }

    @Override
    public void dispose() {
        logger.log(ILevel.DEBUG, "dispose");
        if (this.imageReader.getInput() != null) {
            this.imageReader.dispose();
            try {
                ((ImageInputStream)this.imageReader.getInput()).close();
            }
            catch (IOException exception) {
                logger.log(ILevel.DEBUG, exception.getMessage(), (Throwable)exception);
            }
        }
    }

    @Override
    public int getWidth() {
        return (int)Math.ceil(this.metadata.getWidth());
    }

    @Override
    public int getHeight() {
        return (int)Math.ceil(this.metadata.getHeight());
    }

    @Override
    public int getNumberOfComponents() {
        return this.metadata.getNumberOfComponents();
    }

    @Override
    public int getNumberOfBands() {
        return this.metadata.getNumberOfBands();
    }

    @Override
    public int getColorSpaceType() {
        return this.metadata.getColorSpaceType();
    }

    @Override
    public IImageContainer crop(Rectangle rectangle) {
        return this.crop(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    @Override
    public IImageContainer crop(float x, float y, float width, float height) {
        ObjectList operations = new ObjectList(this.operations);
        ImageCropOperation operation = (ImageCropOperation)operations.stream().instanceOf(ImageCropOperation.class).first().get();
        Optional.of((Object)operation).consume(arg_0 -> ImageIoImageContainer.lambda$0((IMutableObjectList)operations, x, y, width, height, arg_0)).or(() -> ImageIoImageContainer.lambda$1((IMutableObjectList)operations, x, y, width, height));
        return new ImageIoImageContainer(this.hints, new ImageIoImageMetadata(this.metadata.getIndex(), width, height, this.metadata.getNumberOfComponents(), this.metadata.getNumberOfBands(), this.metadata.getColorSpaceType(), this.metadata.getImageType(), this.metadata.getImageMetadata()), this.imageReader, (IObjectList<IImageOperation>)operations);
    }

    @Override
    public IImageContainer fit(int width, int height) {
        float withFactor = this.factor(width, this.getWidth());
        float heightfactor = this.factor(height, this.getHeight());
        return this.scale(Math.max(withFactor, heightfactor));
    }

    private float factor(int numerator, int denominator) {
        return (float)numerator / (float)denominator;
    }

    @Override
    public IImageContainer scale(float widthFactor, float heightFactor) {
        ObjectList operations = new ObjectList(this.operations);
        ImageScaleOperation operation = (ImageScaleOperation)operations.stream().instanceOf(ImageScaleOperation.class).first().get();
        Optional.of((Object)operation).consume(arg_0 -> ImageIoImageContainer.lambda$2((IMutableObjectList)operations, widthFactor, heightFactor, arg_0)).or(() -> ImageIoImageContainer.lambda$3((IMutableObjectList)operations, widthFactor, heightFactor));
        return new ImageIoImageContainer(this.hints, new ImageIoImageMetadata(this.metadata.getIndex(), this.metadata.getWidth() * widthFactor, this.metadata.getHeight() * heightFactor, this.metadata.getNumberOfComponents(), this.metadata.getNumberOfBands(), this.metadata.getColorSpaceType(), this.metadata.getImageType(), this.metadata.getImageMetadata()), this.imageReader, (IObjectList<IImageOperation>)operations);
    }

    @Override
    public IImageContainer scale(float factor) {
        return this.scale(factor, factor);
    }

    @Override
    public IImageContainer invert() {
        ObjectList operations = new ObjectList(this.operations);
        ImageInvertOperation operation = (ImageInvertOperation)operations.stream().instanceOf(ImageInvertOperation.class).first().get();
        Optional.of((Object)operation).consume(arg_0 -> ImageIoImageContainer.lambda$4((IMutableObjectList)operations, arg_0)).or(() -> ImageIoImageContainer.lambda$5((IMutableObjectList)operations));
        return new ImageIoImageContainer(this.hints, new ImageIoImageMetadata(this.metadata.getIndex(), this.metadata.getWidth(), this.metadata.getHeight(), this.metadata.getNumberOfComponents(), this.metadata.getNumberOfBands(), this.metadata.getColorSpaceType(), this.metadata.getImageType(), this.metadata.getImageMetadata()), this.imageReader, (IObjectList<IImageOperation>)operations);
    }

    @Override
    public IImageContainer toGrayScale() {
        ObjectList operations = new ObjectList(this.operations);
        ImageToGrayScaleOperation operation = (ImageToGrayScaleOperation)operations.stream().instanceOf(ImageToGrayScaleOperation.class).first().get();
        Optional.of((Object)operation).or(() -> ImageIoImageContainer.lambda$6((IMutableObjectList)operations));
        return new ImageIoImageContainer(this.hints, new ImageIoImageMetadata(this.metadata.getIndex(), this.metadata.getWidth(), this.metadata.getHeight(), 1, 1, 6, this.metadata.getImageType(), this.metadata.getImageMetadata()), this.imageReader, (IObjectList<IImageOperation>)operations);
    }

    @Override
    public IImageContainer mapBands(int[] bandMapping) {
        if (bandMapping == null || bandMapping.length == 0) {
            return this;
        }
        if (bandMapping.length < this.metadata.getNumberOfComponents()) {
            throw new IllegalArgumentException();
        }
        ObjectList operations = new ObjectList(this.operations);
        ImageCropOperation operation = (ImageCropOperation)operations.stream().instanceOf(ImageCropOperation.class).first().get();
        Optional.of((Object)operation).consume(arg_0 -> ImageIoImageContainer.lambda$7((IMutableObjectList)operations, arg_0));
        operations.add((Object[])new IImageOperation[]{new ImageMapBandsOperation(bandMapping)});
        return new ImageIoImageContainer(this.hints, new ImageIoImageMetadata(this.metadata.getIndex(), this.metadata.getWidth(), this.metadata.getHeight(), this.metadata.getNumberOfComponents(), this.metadata.getNumberOfBands(), this.metadata.getColorSpaceType(), this.metadata.getImageType(), this.metadata.getImageMetadata()), this.imageReader, (IObjectList<IImageOperation>)operations);
    }

    @Override
    public BufferedImage asBufferImage() {
        block17: {
            long size = (long)this.getWidth() * (long)this.getHeight();
            if (size < Integer.MAX_VALUE) break block17;
            logger.log(ILevel.WARNING, "image dimensions (width=" + this.getWidth() + " height=" + this.getHeight() + ") are too large");
            return null;
        }
        ImageReadParam imageReadParameter = this.imageReader.getDefaultReadParam();
        ObjectList operations = new ObjectList();
        ImageScaleOperation imageScaleOperation = null;
        for (IImageOperation operation : this.operations) {
            IImageOperation o;
            if (operation instanceof ImageScaleOperation) {
                imageScaleOperation = (ImageScaleOperation)operation;
                operations.add((Object[])new IImageOperation[]{operation});
                continue;
            }
            if (operation instanceof ImageCropOperation) {
                o = (ImageCropOperation)operation;
                Rectangle2D.Float rectangle = new Rectangle2D.Float(((ImageCropOperation)o).getX(), ((ImageCropOperation)o).getY(), ((ImageCropOperation)o).getWidth(), ((ImageCropOperation)o).getHeight());
                if (imageScaleOperation != null) {
                    AffineTransform transform = AffineTransform.getScaleInstance(imageScaleOperation.getWidthFactor(), imageScaleOperation.getHeightFactor());
                    Shape shape = transform.createTransformedShape(rectangle);
                    imageReadParameter.setSourceRegion(shape.getBounds());
                    imageScaleOperation = null;
                    continue;
                }
                imageReadParameter.setSourceRegion(rectangle.getBounds());
                continue;
            }
            if (operation instanceof ImageMapBandsOperation) {
                o = (ImageMapBandsOperation)operation;
                imageReadParameter.setSourceBands(((ImageMapBandsOperation)o).getBandMapping());
                continue;
            }
            operations.add((Object[])new IImageOperation[]{operation});
        }
        BufferedImage image = this.imageReader.read(this.metadata.getIndex(), imageReadParameter);
        if (operations.isEmpty()) {
            return image;
        }
        IImageContainer bufferedImageContainer = this.bufferedImageContainerFactory.create(image);
        try {
            for (IImageOperation operation : operations) {
                IImageOperation o;
                if (operation instanceof ImageScaleOperation) {
                    o = (ImageScaleOperation)operation;
                    bufferedImageContainer = bufferedImageContainer.scale(((ImageScaleOperation)o).getWidthFactor(), ((ImageScaleOperation)o).getHeightFactor());
                    continue;
                }
                if (operation instanceof ImageCropOperation) {
                    o = (ImageCropOperation)operation;
                    bufferedImageContainer = bufferedImageContainer.crop(((ImageCropOperation)o).getX(), ((ImageCropOperation)o).getX(), ((ImageCropOperation)o).getWidth(), ((ImageCropOperation)o).getHeight());
                    continue;
                }
                if (operation instanceof ImageMapBandsOperation) {
                    o = (ImageMapBandsOperation)operation;
                    bufferedImageContainer = bufferedImageContainer.mapBands(((ImageMapBandsOperation)o).getBandMapping());
                    continue;
                }
                if (operation instanceof ImageInvertOperation) {
                    bufferedImageContainer = bufferedImageContainer.invert();
                    continue;
                }
                if (!(operation instanceof ImageToGrayScaleOperation)) continue;
                bufferedImageContainer = bufferedImageContainer.toGrayScale();
            }
            BufferedImage bufferedImage = bufferedImageContainer.asBufferImage();
            bufferedImageContainer.dispose();
            return bufferedImage;
        }
        catch (Throwable throwable) {
            try {
                bufferedImageContainer.dispose();
                throw throwable;
            }
            catch (IOException exception) {
                logger.log(ILevel.WARNING, exception.getMessage(), (Throwable)exception);
                return new BufferedImage(this.getWidth(), this.getHeight(), this.getColorSpaceType());
            }
        }
    }

    private static /* synthetic */ void lambda$0(IMutableObjectList iMutableObjectList, float f, float f2, float f3, float f4, ImageCropOperation o) throws RuntimeException {
        iMutableObjectList.remove((Object[])new IImageOperation[]{o});
        iMutableObjectList.add((Object[])new IImageOperation[]{new ImageCropOperation(o.getX() + f, o.getY() + f2, f3, f4)});
    }

    private static /* synthetic */ void lambda$1(IMutableObjectList iMutableObjectList, float f, float f2, float f3, float f4) throws RuntimeException {
        iMutableObjectList.add((Object[])new IImageOperation[]{new ImageCropOperation(f, f2, f3, f4)});
    }

    private static /* synthetic */ void lambda$2(IMutableObjectList iMutableObjectList, float f, float f2, ImageScaleOperation o) throws RuntimeException {
        iMutableObjectList.remove((Object[])new IImageOperation[]{o});
        iMutableObjectList.add((Object[])new IImageOperation[]{new ImageScaleOperation(o.getWidthFactor() * f, o.getHeightFactor() * f2)});
    }

    private static /* synthetic */ void lambda$3(IMutableObjectList iMutableObjectList, float f, float f2) throws RuntimeException {
        iMutableObjectList.add((Object[])new IImageOperation[]{new ImageScaleOperation(f, f2)});
    }

    private static /* synthetic */ void lambda$4(IMutableObjectList iMutableObjectList, ImageInvertOperation o) throws RuntimeException {
        iMutableObjectList.remove((Object[])new IImageOperation[]{o});
    }

    private static /* synthetic */ void lambda$5(IMutableObjectList iMutableObjectList) throws RuntimeException {
        iMutableObjectList.add((Object[])new IImageOperation[]{new ImageInvertOperation()});
    }

    private static /* synthetic */ void lambda$6(IMutableObjectList iMutableObjectList) throws RuntimeException {
        iMutableObjectList.add((Object[])new IImageOperation[]{new ImageToGrayScaleOperation()});
    }

    private static /* synthetic */ void lambda$7(IMutableObjectList iMutableObjectList, ImageCropOperation o) throws RuntimeException {
        iMutableObjectList.remove((Object[])new IImageOperation[]{o});
    }
}

