/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.image.imageio;

import java.awt.RenderingHints;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import net.anwiba.commons.image.IImageContainer;
import net.anwiba.commons.image.imageio.ImageIoImageContainer;
import net.anwiba.commons.image.imageio.ImageIoImageMetadata;
import net.anwiba.commons.lang.collection.IObjectList;
import net.anwiba.commons.lang.io.NoneClosingInputStream;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.lang.stream.Streams;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;

public class ImageIoImageContainerFactory {
    private static ILogger logger = Logging.getLogger(ImageIoImageContainerFactory.class);
    private final RenderingHints hints;

    public ImageIoImageContainerFactory(RenderingHints hints) {
        this.hints = hints;
    }

    public IImageContainer create(InputStream inputStream) throws IOException {
        IObjectList imageReaders;
        ImageInputStream imageInputStream;
        block3: {
            NoneClosingInputStream noneClosingInputStream = new NoneClosingInputStream(inputStream);
            noneClosingInputStream.mark(Integer.MAX_VALUE);
            imageInputStream = null;
            try {
                imageInputStream = ImageIO.createImageInputStream(noneClosingInputStream);
                imageReaders = Streams.of(IOException.class, ImageIO.getImageReaders(imageInputStream)).asObjectList();
                if (!imageReaders.isEmpty()) break block3;
                imageInputStream.close();
                return null;
            }
            catch (IOException exception) {
                Optional.of(IOException.class, (Object)imageInputStream).consume(s -> s.close());
                logger.log(ILevel.DEBUG, exception.getMessage(), (Throwable)exception);
                noneClosingInputStream.reset();
                return null;
            }
        }
        ImageReader imageReader = (ImageReader)imageReaders.stream().first().get();
        imageReader.setInput(imageInputStream);
        int index = imageReader.getMinIndex();
        int width = imageReader.getWidth(index);
        int height = imageReader.getHeight(index);
        ImageTypeSpecifier imageType = (ImageTypeSpecifier)Streams.of(IOException.class, imageReader.getImageTypes(index)).first().get();
        IIOMetadata imageMetadata = imageReader.getImageMetadata(index);
        ImageIoImageMetadata metadata = new ImageIoImageMetadata(index, width, height, imageType.getColorModel().getNumColorComponents(), imageType.getNumBands(), imageType.getBufferedImageType(), imageType, imageMetadata);
        return new ImageIoImageContainer(this.hints, metadata, imageReader);
    }
}

