/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.image.jai;

import java.awt.Rectangle;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import net.anwiba.commons.image.IImageContainer;
import net.anwiba.commons.image.jai.JAIImageContainerUtilities;
import net.anwiba.commons.image.jai.PlanarImageContainer;

public abstract class AbstractRenderedImageContainer
implements IImageContainer {
    private final RenderedImage image;

    public AbstractRenderedImageContainer(RenderedImage image) {
        this.image = image;
    }

    @Override
    public int getWidth() {
        return this.image.getWidth();
    }

    @Override
    public int getHeight() {
        return this.image.getHeight();
    }

    @Override
    public IImageContainer crop(float x, float y, float width, float height) {
        RenderedOp cropedRenderOp = JAIImageContainerUtilities.crop(this.image, x, y, width, height);
        RenderedOp translateedRenderOp = JAIImageContainerUtilities.translate((RenderedImage)cropedRenderOp, -x, -y);
        return new PlanarImageContainer((PlanarImage)translateedRenderOp);
    }

    @Override
    public IImageContainer crop(Rectangle rectangle) {
        return this.crop(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    @Override
    public IImageContainer scale(float factor) {
        return this.scale(factor, factor);
    }

    @Override
    public IImageContainer scale(float widthFactor, float heightFactor) {
        RenderedOp scaledRenderOp = JAIImageContainerUtilities.scale(this.image, widthFactor, heightFactor);
        return new PlanarImageContainer((PlanarImage)scaledRenderOp);
    }

    @Override
    public IImageContainer mapBands(int[] mapping) {
        if (mapping == null || mapping.length == 0 || this.isSorted(mapping)) {
            return this;
        }
        RenderedOp renderedOp = JAI.create((String)"bandselect", (RenderedImage)this.image, (Object)mapping);
        return new PlanarImageContainer((PlanarImage)renderedOp);
    }

    @Override
    public IImageContainer invert() {
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(this.image);
        RenderedOp renderedOp = JAI.create((String)"invert", (ParameterBlock)pb, null);
        return new PlanarImageContainer((PlanarImage)renderedOp);
    }

    @Override
    public IImageContainer toGrayScale() {
        return new PlanarImageContainer(JAIImageContainerUtilities.toGrayScale(this.image));
    }

    private boolean isSorted(int[] mapping) {
        int i = 0;
        while (i < mapping.length) {
            if (i != mapping[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public IImageContainer fit(int width, int height) {
        float factor = this.fitFactor(width, height);
        return this.scale(factor);
    }

    private float fitFactor(int width, int height) {
        float withFactor = this.factor(width, this.getWidth());
        float heightfactor = this.factor(height, this.getHeight());
        return Math.max(withFactor, heightfactor);
    }

    private float factor(int numerator, int denominator) {
        return (float)numerator / (float)denominator;
    }

    @Override
    public int getColorSpaceType() {
        return this.image.getColorModel().getColorSpace().getType();
    }
}

