/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.jdbc;

import java.lang.invoke.LambdaMetafactory;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import net.anwiba.commons.jdbc.BatchTransfer;
import net.anwiba.commons.jdbc.IBatchTransfer;
import net.anwiba.commons.jdbc.connection.IDatabaseConnector;
import net.anwiba.commons.jdbc.connection.IJdbcConnectionDescription;
import net.anwiba.commons.jdbc.constraint.Constraint;
import net.anwiba.commons.jdbc.constraint.ConstraintType;
import net.anwiba.commons.jdbc.result.IResult;
import net.anwiba.commons.jdbc.result.IResults;
import net.anwiba.commons.jdbc.result.ResultSetToResultAdapter;
import net.anwiba.commons.jdbc.result.ResultSetToResultsAdapter;
import net.anwiba.commons.jdbc.value.IDatabaseValue;
import net.anwiba.commons.lang.exception.CanceledException;
import net.anwiba.commons.lang.functional.ConversionException;
import net.anwiba.commons.lang.functional.IAggregator;
import net.anwiba.commons.lang.functional.IApplicable;
import net.anwiba.commons.lang.functional.IBlock;
import net.anwiba.commons.lang.functional.IClosableIterator;
import net.anwiba.commons.lang.functional.ICloseableConsumer;
import net.anwiba.commons.lang.functional.IConverter;
import net.anwiba.commons.lang.functional.IFactory;
import net.anwiba.commons.lang.functional.IFunction;
import net.anwiba.commons.lang.functional.IInterruptableFunction;
import net.anwiba.commons.lang.functional.IInterruptableProcedure;
import net.anwiba.commons.lang.functional.IProcedure;
import net.anwiba.commons.lang.functional.IWatcher;
import net.anwiba.commons.lang.number.ComparableNumber;
import net.anwiba.commons.lang.object.ObjectUtilities;
import net.anwiba.commons.lang.optional.IOptional;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.utilities.collection.IterableUtilities;
import net.anwiba.commons.utilities.string.StringUtilities;

public class DatabaseUtilities {
    private static ILogger logger = Logging.getLogger((String)DatabaseUtilities.class.getName());

    public static Driver loadDriver(String driverName) {
        try {
            Enumeration<Driver> drivers = DriverManager.getDrivers();
            while (drivers.hasMoreElements()) {
                Driver driver = drivers.nextElement();
                if (!driver.getClass().getName().equals(driverName)) continue;
                return driver;
            }
            Class<?> driverClass = Class.forName(driverName);
            if (driverClass != null) {
                Driver driver = (Driver)driverClass.newInstance();
                DriverManager.registerDriver(driver);
                return driver;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (SQLException sQLException) {}
        return null;
    }

    public static Connection createConnection(String url, String user, String password, boolean isReadOnly) throws SQLException {
        Connection connection = DriverManager.getConnection(url, user, password);
        connection.setReadOnly(isReadOnly);
        return connection;
    }

    public static Connection createConnection(String url, String user, String password) throws SQLException {
        return DriverManager.getConnection(url, user, password);
    }

    public static void close(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException sQLException) {}
    }

    public static SQLException close(Connection connection, SQLException exception) {
        if (connection == null) {
            return exception;
        }
        try {
            connection.close();
            return exception;
        }
        catch (SQLException sqlException) {
            if (exception == null) {
                return sqlException;
            }
            exception.addSuppressed(sqlException);
            return exception;
        }
    }

    public static SQLException close(Statement statement, SQLException exception) {
        if (statement == null) {
            return exception;
        }
        try {
            statement.close();
            return exception;
        }
        catch (SQLException sqlException) {
            if (exception == null) {
                return sqlException;
            }
            exception.addSuppressed(sqlException);
            return exception;
        }
    }

    public static SQLException close(ResultSet resultSet, SQLException exception) {
        if (resultSet == null) {
            return exception;
        }
        try {
            resultSet.close();
            return exception;
        }
        catch (SQLException sqlException) {
            if (exception == null) {
                return sqlException;
            }
            exception.addSuppressed(sqlException);
            return exception;
        }
    }

    public static SQLException close(IResults results, SQLException exception) {
        if (results == null) {
            return exception;
        }
        try {
            results.close();
            return exception;
        }
        catch (SQLException sqlException) {
            if (exception == null) {
                return sqlException;
            }
            exception.addSuppressed(sqlException);
            return exception;
        }
    }

    public static void close(IResults results) {
        try {
            if (results != null) {
                results.close();
            }
        }
        catch (SQLException sQLException) {}
    }

    public static void close(Statement statement) {
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {}
    }

    public static void close(ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {}
    }

    public static String getStatementString(Connection connection, double beforVersion, String statement, String defaultStatement) throws SQLException {
        double version = DatabaseUtilities.getVersionAsDouble(connection);
        if (version < beforVersion) {
            return statement;
        }
        return defaultStatement;
    }

    public static double getVersionAsDouble(Connection connection) throws SQLException {
        int mayor = DatabaseUtilities.getMajorVersion(connection);
        int minor = DatabaseUtilities.getMinorVersion(connection);
        double version = (double)mayor + Double.parseDouble("0." + String.valueOf(minor));
        return version;
    }

    public static String getProduct(Connection connection) throws SQLException {
        return connection.getMetaData().getDatabaseProductName();
    }

    public static String getVersion(Connection connection) throws SQLException {
        return connection.getMetaData().getDatabaseProductVersion();
    }

    public static int getMajorVersion(Connection connection) throws SQLException {
        return connection.getMetaData().getDatabaseMajorVersion();
    }

    public static int getMinorVersion(Connection connection) throws SQLException {
        return connection.getMetaData().getDatabaseMinorVersion();
    }

    public static Map<String, Constraint> readConstraints(Connection connection, String selectStatement, String schemaName, String tableName) throws SQLException {
        logger.log(ILevel.DEBUG, "Query: Schema " + schemaName + " table " + tableName);
        logger.log(ILevel.DEBUG, "Query: " + selectStatement);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (PreparedStatement statement = connection.prepareStatement(selectStatement);){
                HashMap<String, Constraint> constraints = new HashMap<String, Constraint>();
                statement.setString(1, schemaName);
                statement.setString(2, tableName);
                if (statement.execute()) {
                    Throwable throwable2 = null;
                    Object var9_13 = null;
                    try (ResultSet resultSet = statement.getResultSet();){
                        while (resultSet.next()) {
                            String columnName = resultSet.getString(1);
                            String constraintName = resultSet.getString(2);
                            ConstraintType constraintType = ConstraintType.getTypeById(resultSet.getString(3));
                            String condition = resultSet.getString(4);
                            Constraint constraint = DatabaseUtilities.getConstraint(constraints, constraintName, constraintType, condition);
                            constraint.add(columnName);
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                return constraints;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (SQLException exception) {
            throw new SQLException("Executing statement '" + selectStatement + "' faild", exception);
        }
    }

    private static Constraint getConstraint(Map<String, Constraint> constraints, String constraintName, ConstraintType constraintType, String condition) {
        Constraint constraint = constraints.get(constraintName);
        if (constraint == null) {
            constraint = new Constraint(constraintName, constraintType, condition);
            constraints.put(constraintName, constraint);
        }
        return constraint;
    }

    public static void dropTable(Connection connection, String schemaName, String tableName) throws SQLException {
        String qualifiedTableName = schemaName == null ? tableName : String.valueOf(schemaName) + "." + tableName;
        String statementString = "DROP TABLE " + qualifiedTableName;
        DatabaseUtilities.execute(connection, statementString);
    }

    public static void dropIndex(Connection connection, String schemaName, String indexName) throws SQLException {
        String qualifiedIndexName = schemaName == null ? indexName : String.valueOf(schemaName) + "." + indexName;
        String statementString = "DROP INDEX " + qualifiedIndexName;
        DatabaseUtilities.execute(connection, statementString);
    }

    public static String getOwner(Connection connection, String owner) throws SQLException {
        return owner == null ? connection.getMetaData().getUserName() : owner;
    }

    public static <T> List<T> results(IDatabaseConnector connector, IJdbcConnectionDescription connectionDescription, String statementString, IConverter<IResult, T, SQLException> function) throws SQLException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (Connection connection = connector.connectReadOnly(connectionDescription);){
            return DatabaseUtilities.results(connection, statementString, function);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static <T> List<T> results(IDatabaseConnector connector, IJdbcConnectionDescription connectionDescription, String statementString, IProcedure<PreparedStatement, SQLException> prepareProcedure, IConverter<IResult, T, SQLException> function) throws SQLException {
        Throwable throwable = null;
        Object var6_7 = null;
        try (Connection connection = connector.connectReadOnly(connectionDescription);){
            return DatabaseUtilities.results(connection, statementString, prepareProcedure, function);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static <T> List<T> results(Connection connection, String statementString, IConverter<IResult, T, SQLException> function) throws SQLException {
        return DatabaseUtilities.results(connection, statementString, (IProcedure<PreparedStatement, SQLException>)((IProcedure)statement -> {}), function);
    }

    public static <T> List<T> results(Connection connection, String statementString, IProcedure<PreparedStatement, SQLException> prepareProcedure, IConverter<IResult, T, SQLException> resultProcedure) throws SQLException {
        logger.log(ILevel.DEBUG, "Statement: " + statementString);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (PreparedStatement statement = connection.prepareStatement(statementString);){
                prepareProcedure.execute((Object)statement);
                ArrayList<Object> resultList = new ArrayList<Object>();
                if (statement.execute()) {
                    Throwable throwable2 = null;
                    Object var9_13 = null;
                    try (ResultSet resultSet = statement.getResultSet();){
                        ResultSetToResultAdapter result = new ResultSetToResultAdapter(resultSet);
                        while (resultSet.next()) {
                            Object object = resultProcedure.convert((Object)result);
                            if (object == null) continue;
                            resultList.add(object);
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                return resultList;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (SQLException exception) {
            throw new SQLException("Executing statement '" + statementString + "' faild", exception);
        }
    }

    public static <T> List<T> results(IFactory<IBlock<RuntimeException>, IWatcher, RuntimeException> cancelWatcherFactory, Connection connection, String statementString, IConverter<IResult, T, SQLException> resultFunction) throws SQLException {
        return DatabaseUtilities.results(cancelWatcherFactory, connection, statementString, (IProcedure<PreparedStatement, SQLException>)((IProcedure)s -> {}), resultFunction);
    }

    /*
     * Exception decompiling
     */
    public static <T> List<T> results(IFactory<IBlock<RuntimeException>, IWatcher, RuntimeException> cancelWatcherFactory, Connection connection, String statementString, IProcedure<PreparedStatement, SQLException> prepareProcedure, IConverter<IResult, T, SQLException> resultConverter) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static ResultSet resultSet(Connection connection, String string) throws SQLException {
        return DatabaseUtilities.resultSet(connection, string, (IProcedure<PreparedStatement, SQLException>)((IProcedure)value -> {}));
    }

    public static <T> ResultSet resultSet(Connection connection, String statementString, IProcedure<PreparedStatement, SQLException> prepareProcedure) throws SQLException {
        try {
            logger.log(ILevel.DEBUG, "Statement: " + statementString);
            PreparedStatement statement = connection.prepareStatement(statementString);
            prepareProcedure.execute((Object)statement);
            if (statement.execute()) {
                return statement.getResultSet();
            }
            return null;
        }
        catch (SQLException exception) {
            throw new SQLException("Executing statement '" + statementString + "' faild", exception);
        }
    }

    public static String stringResult(IDatabaseConnector connector, IJdbcConnectionDescription connectionDescription, String statementString, IProcedure<PreparedStatement, SQLException> prepareProcedure) throws SQLException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (Connection connection = connector.connectReadOnly(connectionDescription);){
            return DatabaseUtilities.stringResult(connection, statementString, prepareProcedure);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static String stringResult(Connection connection, String statementString, Object ... values) throws SQLException {
        return DatabaseUtilities.stringResult(connection, statementString, DatabaseUtilities.setterProcedur(values));
    }

    public static String stringResult(Connection connection, String statementString, IProcedure<PreparedStatement, SQLException> prepareProcedure) throws SQLException {
        IFunction<IResult, String, SQLException> resultFunction = new IFunction<IResult, String, SQLException>(){

            public String execute(IResult value) throws SQLException {
                if (value == null) {
                    return null;
                }
                return value.getString(1);
            }
        };
        return DatabaseUtilities.stringResult(connection, statementString, prepareProcedure, resultFunction);
    }

    public static String stringResult(Connection connection, String statementString, IProcedure<PreparedStatement, SQLException> prepareProcedure, IConverter<IOptional<IResult, SQLException>, String, SQLException> resultFunction) throws SQLException {
        return DatabaseUtilities.result(connection, statementString, prepareProcedure, resultFunction);
    }

    public static Long longResult(IDatabaseConnector connector, IJdbcConnectionDescription connectionDescription, String statementString, IProcedure<PreparedStatement, SQLException> prepareProcedure) throws SQLException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (Connection connection = connector.connectReadOnly(connectionDescription);){
            return DatabaseUtilities.longResult(connection, statementString, prepareProcedure);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static Long longResult(Connection connection, String statementString, Object ... values) throws SQLException {
        return DatabaseUtilities.longResult(connection, statementString, DatabaseUtilities.setterProcedur(values));
    }

    public static Long longResult(Connection connection, String statementString, IProcedure<PreparedStatement, SQLException> prepareProcedure) throws SQLException {
        IConverter<IResult, Long, SQLException> resultFunction = new IConverter<IResult, Long, SQLException>(){

            public Long convert(IResult value) throws SQLException {
                if (value == null) {
                    return null;
                }
                return value.getLong(1);
            }
        };
        return DatabaseUtilities.longResult(connection, statementString, new Object[]{prepareProcedure, resultFunction});
    }

    public static Long longResult(Connection connection, String statementString, IProcedure<PreparedStatement, SQLException> prepareProcedure, IConverter<IOptional<IResult, SQLException>, Long, SQLException> resultFunction) throws SQLException {
        return DatabaseUtilities.result(connection, statementString, prepareProcedure, resultFunction);
    }

    public static boolean booleanResult(IDatabaseConnector connector, IJdbcConnectionDescription connectionDescription, String statementString, IProcedure<PreparedStatement, SQLException> prepareProcedure) throws SQLException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (Connection connection = connector.connectReadOnly(connectionDescription);){
            return DatabaseUtilities.booleanResult(connection, statementString, prepareProcedure);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static boolean booleanResult(Connection connection, String statementString, Object ... values) throws SQLException {
        return DatabaseUtilities.booleanResult(connection, statementString, DatabaseUtilities.setterProcedur(values));
    }

    public static boolean booleanResult(Connection connection, String statementString, IProcedure<PreparedStatement, SQLException> prepareProcedure) throws SQLException {
        return DatabaseUtilities.result(connection, statementString, prepareProcedure, new IConverter<IOptional<IResult, SQLException>, Boolean, SQLException>(){

            public Boolean convert(IOptional<IResult, SQLException> value) throws SQLException {
                return (Boolean)value.convert(v -> v.getBoolean(1, false)).getOr(() -> Boolean.FALSE);
            }
        });
    }

    public static <T> T result(IDatabaseConnector connector, IJdbcConnectionDescription connectionDescription, String statementString, IProcedure<PreparedStatement, SQLException> prepareProcedure, IConverter<IOptional<IResult, SQLException>, T, SQLException> resultFunction) throws SQLException {
        Throwable throwable = null;
        Object var6_7 = null;
        try (Connection connection = connector.connectReadOnly(connectionDescription);){
            return DatabaseUtilities.result(connection, statementString, prepareProcedure, resultFunction);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static <T> T result(IDatabaseConnector connector, IJdbcConnectionDescription connectionDescription, String statementString, IConverter<IOptional<IResult, SQLException>, T, SQLException> resultFunction) throws SQLException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (Connection connection = connector.connectReadOnly(connectionDescription);){
            return DatabaseUtilities.result(connection, statementString, resultFunction);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static <T> T result(Connection connection, String statementString, IConverter<IOptional<IResult, SQLException>, T, SQLException> function) throws SQLException {
        return DatabaseUtilities.result(connection, statementString, (IProcedure<PreparedStatement, SQLException>)((IProcedure)statement -> {}), function);
    }

    /*
     * Exception decompiling
     */
    public static <T> T result(Connection connection, String statementString, IProcedure<PreparedStatement, SQLException> prepareProcedure, IConverter<IOptional<IResult, SQLException>, T, SQLException> resultFunction) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static <T> List<T> results(Connection connection, String statementString, IInterruptableFunction<IResult, T, SQLException> resultFunction) throws SQLException, CanceledException {
        return DatabaseUtilities.results((IFactory<IBlock<RuntimeException>, IWatcher, RuntimeException>)((IFactory)b -> () -> {}), connection, statementString, (IInterruptableProcedure<PreparedStatement, SQLException>)((IInterruptableProcedure)s -> {}), resultFunction);
    }

    public static <T> List<T> results(IDatabaseConnector connector, IJdbcConnectionDescription connectionDescription, String statementString, IInterruptableFunction<IResult, T, SQLException> resultFunction) throws SQLException, CanceledException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (Connection connection = connector.connectReadOnly(connectionDescription);){
            return DatabaseUtilities.results((IFactory<IBlock<RuntimeException>, IWatcher, RuntimeException>)((IFactory)b -> () -> {}), connection, statementString, (IInterruptableProcedure<PreparedStatement, SQLException>)((IInterruptableProcedure)s -> {}), resultFunction);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static <T> List<T> results(Connection connection, String statementString, IInterruptableProcedure<PreparedStatement, SQLException> prepareClosure, IInterruptableFunction<IResult, T, SQLException> resultFunction) throws SQLException, CanceledException {
        return DatabaseUtilities.results((IFactory<IBlock<RuntimeException>, IWatcher, RuntimeException>)((IFactory)b -> () -> {}), connection, statementString, prepareClosure, resultFunction);
    }

    /*
     * Exception decompiling
     */
    public static <T> List<T> results(IFactory<IBlock<RuntimeException>, IWatcher, RuntimeException> cancelWatcherFactory, Connection connection, String statementString, IInterruptableProcedure<PreparedStatement, SQLException> prepareClosure, IInterruptableFunction<IResult, T, SQLException> resultProcedure) throws SQLException, CanceledException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static <T> T aggregate(IDatabaseConnector connector, IJdbcConnectionDescription connectionDescription, String statementString, IConverter<Iterable<IResult>, T, SQLException> function) throws SQLException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (Connection connection = connector.connectReadOnly(connectionDescription);){
            return DatabaseUtilities.aggregate(connection, statementString, function);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static <T> T aggregate(Connection connection, String statementString, IConverter<Iterable<IResult>, T, SQLException> function) throws SQLException {
        return DatabaseUtilities.aggregate(connection, statementString, (IProcedure<PreparedStatement, SQLException>)((IProcedure)statement -> {}), function);
    }

    /*
     * Unable to fully structure code
     */
    public static <T> T aggregate(Connection connection, String statementString, IProcedure<PreparedStatement, SQLException> prepareProcedure, IConverter<Iterable<IResult>, T, SQLException> resultProcedure) throws SQLException {
        DatabaseUtilities.logger.log(ILevel.DEBUG, "Statement: " + statementString);
        try {
            var4_4 = null;
            var5_7 = null;
            try {
                statement = connection.prepareStatement(statementString);
                try {
                    prepareProcedure.execute((Object)statement);
                    if (statement.execute()) {
                        var7_10 = null;
                        var8_12 = null;
                        try {
                            resultSet = statement.getResultSet();
                            try {
                                exceptions = new ArrayList<E>(4);
                                result = new ResultSetToResultAdapter(resultSet);
                                iterable = (Iterable<T>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/util/Iterator;, lambda$12(java.sql.ResultSet java.util.List net.anwiba.commons.jdbc.result.IResult ), ()Ljava/util/Iterator;)((ResultSet)resultSet, exceptions, (IResult)result);
                                try {
                                    v0 = resultProcedure.convert(iterable);
                                }
                                catch (SQLException exception) {
                                    ** for (sqlException : exceptions)
                                }
                                while (true) {
                                    if (statement != null) {
                                        statement.close();
                                    }
                                    return (T)v0;
                                }
lbl-1000:
                                // 1 sources

                                {
                                    sqlException.addSuppressed(exception);
                                    exception = sqlException;
                                    continue;
                                }
lbl30:
                                // 1 sources

                                throw exception;
                            }
                            finally {
                                if (resultSet == null) ** continue;
                                resultSet.close();
                            }
                        }
                        catch (Throwable var8_13) {
                            if (var7_10 == null) {
                                var7_10 = var8_13;
                            } else if (var7_10 != var8_13) {
                                var7_10.addSuppressed(var8_13);
                            }
                            throw var7_10;
                        }
                    }
                    return (T)resultProcedure.convert(new ArrayList<E>());
                }
                catch (Throwable var4_5) {
                    throw var4_5;
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
            catch (Throwable var5_8) {
                if (var4_4 == null) {
                    var4_4 = var5_8;
                } else if (var4_4 != var5_8) {
                    var4_4.addSuppressed(var5_8);
                }
                throw var4_4;
            }
        }
        catch (SQLException exception) {
            throw new SQLException("Executing statement '" + statementString + "' faild", exception);
        }
    }

    /*
     * Exception decompiling
     */
    public static boolean execute(Connection connection, String statementString, IProcedure<PreparedStatement, SQLException> prepareProcedure, IProcedure<ResultSet, SQLException> resultProcedure) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[CATCHBLOCK], 0[TRYBLOCK], 3[TRYBLOCK], 11[CATCHBLOCK], 1[TRYBLOCK], 2[TRYBLOCK]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static final boolean execute(Connection connection, String statementString, Object ... values) throws SQLException {
        return DatabaseUtilities.execute(connection, statementString, DatabaseUtilities.setterProcedur(values), (IProcedure<ResultSet, SQLException>)((IProcedure)each -> {}));
    }

    public static final boolean call(Connection connection, String statementString, Object ... values) throws SQLException {
        return DatabaseUtilities.call(connection, statementString, DatabaseUtilities.setterProcedur(values), (IProcedure<ResultSet, SQLException>)((IProcedure)each -> {}));
    }

    public static final boolean call(Connection connection, String statementString, IProcedure<PreparedStatement, SQLException> procedure) throws SQLException {
        return DatabaseUtilities.call(connection, statementString, procedure, (IProcedure<ResultSet, SQLException>)((IProcedure)each -> {}));
    }

    /*
     * Exception decompiling
     */
    public static boolean call(Connection connection, String statementString, IProcedure<PreparedStatement, SQLException> prepareProcedure, IProcedure<ResultSet, SQLException> resultProcedure) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK], 12[CATCHBLOCK], 1[TRYBLOCK], 3[TRYBLOCK], 0[TRYBLOCK], 11[CATCHBLOCK]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static IProcedure<PreparedStatement, SQLException> setterProcedur(Object ... objects) {
        return statement -> {
            int i = 0;
            while (i < objects.length) {
                logger.log(ILevel.DEBUG, "  value: " + DatabaseUtilities.toDebugString(objects[i]));
                Object adjustValue = DatabaseUtilities.adjustValue(objects[i]);
                if (adjustValue == null) {
                    statement.setNull(i + 1, 0);
                } else {
                    statement.setObject(i + 1, adjustValue);
                }
                ++i;
            }
        };
    }

    public static Object adjustValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof java.util.Date && !(value instanceof Date) && !(value instanceof Timestamp) && !(value instanceof Time)) {
            return new Timestamp(((java.util.Date)value).getTime());
        }
        if (value instanceof ComparableNumber) {
            return DatabaseUtilities.adjustValue(value);
        }
        if (value instanceof Double) {
            if (Double.isNaN((Double)value)) {
                return null;
            }
            return value;
        }
        return value;
    }

    public static int count(IDatabaseConnector connector, IJdbcConnectionDescription connectionDescription, String statementString, Object ... values) throws SQLException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (Connection connection = connector.connectReadOnly(connectionDescription);){
            return DatabaseUtilities.count(connection, statementString, values);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static int count(Connection connection, String statementString, Object ... values) throws SQLException {
        return DatabaseUtilities.count(connection, statementString, DatabaseUtilities.setterProcedur(values));
    }

    /*
     * Exception decompiling
     */
    public static Long next(Connection connection, String nextValueStatement) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static int count(Connection connection, String statementString, IProcedure<PreparedStatement, SQLException> prepareProcedure) throws SQLException {
        logger.log(ILevel.DEBUG, "Statement: " + statementString);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (PreparedStatement statement = connection.prepareStatement(statementString);){
                return DatabaseUtilities.count(statement, prepareProcedure);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException exception) {
            throw new SQLException("Executing statement '" + statementString + "' faild", exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int count(PreparedStatement statement, IProcedure<PreparedStatement, SQLException> prepareProcedure) throws SQLException {
        prepareProcedure.execute((Object)statement);
        if (!statement.execute()) return 0;
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            ResultSet resultSet = statement.getResultSet();
            try {
                if (!resultSet.next()) return 0;
                Object object = resultSet.getObject(1);
                if (!(object instanceof Number)) {
                    return 0;
                }
                Number number = (Number)object;
                return number.intValue();
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                if (resultSet == null) return 0;
                resultSet.close();
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }

    public static boolean contains(Connection connection, String statementString, String columnName, Object value) throws SQLException {
        Boolean count = (Boolean)DatabaseUtilities.aggregate(connection, statementString, results -> {
            for (IResult result : results) {
                Object object2 = result.getObject(columnName);
                if (!ObjectUtilities.equals((Object)value, (Object)object2)) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        });
        return count;
    }

    public static boolean execute(Connection connection, String statementString) throws SQLException {
        return DatabaseUtilities.execute(connection, statementString, (IProcedure<PreparedStatement, SQLException>)((IProcedure)statement -> {}));
    }

    public static final boolean execute(Connection connection, String statementString, IProcedure<PreparedStatement, SQLException> procedure) throws SQLException {
        return DatabaseUtilities.execute(connection, statementString, procedure, (IProcedure<ResultSet, SQLException>)((IProcedure)each -> {}));
    }

    public static void execute(IDatabaseConnector connector, IJdbcConnectionDescription connectionDescription, IProcedure<Connection, SQLException> procedure) throws SQLException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (Connection connection = connector.connectWritable(connectionDescription);){
            procedure.execute((Object)connection);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static boolean exists(IDatabaseConnector connector, IJdbcConnectionDescription connectionDescription) {
        Throwable throwable = null;
        Object var3_5 = null;
        Connection connection = connector.connectReadOnly(connectionDescription);
        if (connection != null) {
            connection.close();
        }
        try {
            return true;
        }
        catch (Throwable throwable2) {
            try {
                if (connection != null) {
                    connection.close();
                }
                throw throwable2;
            }
            catch (Throwable throwable3) {
                try {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
                catch (SQLException exception) {
                    logger.log(ILevel.WARNING, exception.getMessage(), (Throwable)exception);
                    return false;
                }
            }
        }
    }

    public static List<Object> update(Connection connection, String statementString, String[] returnColumns, Object ... values) throws SQLException {
        return DatabaseUtilities.update(connection, statementString, returnColumns, DatabaseUtilities.setterProcedur(values));
    }

    public static List<Object> update(IDatabaseConnector connector, IJdbcConnectionDescription connectionDescription, String updatetStatement, String[] returnColumns, IProcedure<PreparedStatement, SQLException> prepareProcedure) throws SQLException {
        Throwable throwable = null;
        Object var6_7 = null;
        try (Connection connection = connector.connectWritable(connectionDescription);){
            return DatabaseUtilities.update(connection, updatetStatement, returnColumns, prepareProcedure);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<Object> update(Connection connection, String statementString, String[] returnColumns, IProcedure<PreparedStatement, SQLException> prepareProcedure) throws SQLException {
        logger.log(ILevel.DEBUG, "Statement: " + statementString);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try {
                ArrayList<Object> arrayList;
                PreparedStatement statement = connection.prepareStatement(statementString, returnColumns);
                try {
                    prepareProcedure.execute((Object)statement);
                    int numberOfChangedRows = statement.executeUpdate();
                    if (numberOfChangedRows == 0) {
                        arrayList = new ArrayList<Object>();
                        return arrayList;
                    }
                    ArrayList<Object> keys = new ArrayList<Object>();
                    Throwable throwable2 = null;
                    Object var10_14 = null;
                    try (ResultSet generatedKeys = statement.getGeneratedKeys();){
                        while (generatedKeys.next()) {
                            Object key = generatedKeys.getObject(1);
                            logger.log(ILevel.DEBUG, "    key: " + DatabaseUtilities.toDebugString(key));
                            keys.add(key);
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                            throw throwable2;
                        }
                        if (throwable2 == throwable3) throw throwable2;
                        throwable2.addSuppressed(throwable3);
                        throw throwable2;
                    }
                    return keys;
                }
                catch (Throwable throwable4) {
                    throw throwable4;
                }
                finally {
                    if (statement == null) return arrayList;
                    statement.close();
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                    throw throwable;
                }
                if (throwable == throwable5) throw throwable;
                throwable.addSuppressed(throwable5);
                throw throwable;
            }
        }
        catch (SQLException exception) {
            throw new SQLException("Executing statement '" + statementString + "' faild", exception);
        }
    }

    public static List<Object> update(Connection connection, String statementString, Object ... values) throws SQLException {
        return DatabaseUtilities.update(connection, statementString, DatabaseUtilities.setterProcedur(values));
    }

    public static List<Object> update(IDatabaseConnector connector, IJdbcConnectionDescription connectionDescription, String updatetStatement, IProcedure<PreparedStatement, SQLException> prepareProcedure) throws SQLException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (Connection connection = connector.connectWritable(connectionDescription);){
            return DatabaseUtilities.update(connection, updatetStatement, prepareProcedure);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<Object> update(Connection connection, String statementString, IProcedure<PreparedStatement, SQLException> prepareProcedure) throws SQLException {
        logger.log(ILevel.DEBUG, "Statement: " + statementString);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                ArrayList<Object> arrayList;
                PreparedStatement statement = connection.prepareStatement(statementString, 1);
                try {
                    prepareProcedure.execute((Object)statement);
                    int numberOfChangedRows = statement.executeUpdate();
                    if (numberOfChangedRows == 0) {
                        arrayList = new ArrayList<Object>();
                        return arrayList;
                    }
                    ArrayList<Object> keys = new ArrayList<Object>();
                    Throwable throwable2 = null;
                    Object var9_14 = null;
                    try (ResultSet generatedKeys = statement.getGeneratedKeys();){
                        while (generatedKeys.next()) {
                            Object key = generatedKeys.getObject(1);
                            logger.log(ILevel.DEBUG, "    key: " + DatabaseUtilities.toDebugString(key));
                            keys.add(key);
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                            throw throwable2;
                        }
                        if (throwable2 == throwable3) throw throwable2;
                        throwable2.addSuppressed(throwable3);
                        throw throwable2;
                    }
                    ArrayList<Object> arrayList2 = keys;
                    return arrayList2;
                }
                finally {
                    if (statement == null) return arrayList;
                    statement.close();
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        catch (SQLException exception) {
            throw new SQLException("Executing statement '" + statementString + "' faild", exception);
        }
    }

    public static <I> ICloseableConsumer<I, Boolean, SQLException> update(IFactory<IBlock<RuntimeException>, IWatcher, RuntimeException> cancelWatcherFactory, final Connection connection, String statementString, final IConverter<I, List<IDatabaseValue>, SQLException> converter) {
        IAggregator aggregator = new IAggregator<PreparedStatement, I, Boolean, SQLException>(){

            public Boolean aggregate(PreparedStatement statement, I object) throws SQLException {
                List values = (List)converter.convert(object);
                if (values.isEmpty()) {
                    return false;
                }
                int i = 0;
                while (i < values.size()) {
                    this.setTo(statement, i + 1, (IDatabaseValue)values.get(i));
                    ++i;
                }
                return true;
            }

            private void setTo(PreparedStatement statement, int i, IDatabaseValue value) throws SQLException {
                try {
                    if (value.getObject(connection) == null) {
                        if (value.getTypeName() != null) {
                            statement.setNull(i, value.getType(), value.getTypeName());
                        } else {
                            statement.setNull(i, value.getType());
                        }
                        return;
                    }
                    statement.setObject(i, value.getObject(connection));
                }
                catch (SQLException exception) {
                    logger.log(ILevel.WARNING, "Couldn't set value on column '" + i + "'", (Throwable)exception);
                    if (value.getTypeName() != null) {
                        statement.setNull(i, value.getType(), value.getTypeName());
                    }
                    statement.setNull(i, value.getType());
                }
            }
        };
        return DatabaseUtilities.update(cancelWatcherFactory, connection, statementString, aggregator);
    }

    public static <I> ICloseableConsumer<I, Boolean, SQLException> update(final IFactory<IBlock<RuntimeException>, IWatcher, RuntimeException> cancelWatcherFactory, final Connection connection, final String statementString, final IAggregator<PreparedStatement, I, Boolean, SQLException> aggregator) {
        return new ICloseableConsumer<I, Boolean, SQLException>(){
            private IWatcher statementCancler;
            private boolean isClosed = false;
            private PreparedStatement statement;

            public void close() throws SQLException {
                if (this.isClosed) {
                    throw new SQLException("consumer is closed");
                }
                this.isClosed = true;
                this.statementCancler.close();
                SQLException exception = DatabaseUtilities.close(this.statement, null);
                if (exception != null) {
                    throw exception;
                }
            }

            public Boolean consume(I object) throws SQLException {
                Boolean aggregated;
                if (this.isClosed) {
                    throw new SQLException("consumer is closed");
                }
                if (this.statement == null) {
                    this.initialize();
                }
                if ((aggregated = (Boolean)aggregator.aggregate((Object)this.statement, object)).booleanValue()) {
                    this.statement.addBatch();
                }
                return aggregated;
            }

            private void initialize() throws SQLException {
                logger.log(ILevel.DEBUG, statementString);
                this.statement = connection.prepareStatement(statementString);
                this.statementCancler = (IWatcher)cancelWatcherFactory.create(() -> {
                    try {
                        this.statement.cancel();
                    }
                    catch (SQLException sQLException) {}
                });
            }
        };
    }

    public static void add(PreparedStatement statement, Object ... values) throws SQLException {
        DatabaseUtilities.add(statement, DatabaseUtilities.setterProcedur(values));
    }

    public static void add(PreparedStatement statement, IProcedure<PreparedStatement, SQLException> prepareProcedure) throws SQLException {
        prepareProcedure.execute((Object)statement);
        statement.addBatch();
    }

    public static int[] transfer(PreparedStatement statement) throws SQLException {
        return statement.executeBatch();
    }

    public IDatabaseValue value(Object object, int type) {
        return this.value(object, type, null);
    }

    public IDatabaseValue value(final Object object, final int type, final String typeName) {
        return new IDatabaseValue(){

            @Override
            public String getTypeName() {
                return typeName;
            }

            @Override
            public int getType() {
                return type;
            }

            @Override
            public Object getObject(Connection connection) throws SQLException {
                return object;
            }
        };
    }

    public static <T> IClosableIterator<T, SQLException> query(final IFactory<IBlock<RuntimeException>, IWatcher, RuntimeException> cancelWatcherFactory, final Connection connection, final String statementString, final IProcedure<PreparedStatement, SQLException> prepareProcedure, final IConverter<IResult, T, SQLException> converter) {
        return new IClosableIterator<T, SQLException>(){
            private boolean isClosed = false;
            private IResults results;
            private T value;
            private IWatcher statementCancler;
            private PreparedStatement statement;

            public void close() throws SQLException {
                if (this.isClosed) {
                    throw new SQLException("iterator is closed");
                }
                this.statementCancler.close();
                SQLException exception = DatabaseUtilities.close(this.results, null);
                exception = DatabaseUtilities.close(this.statement, exception);
                this.isClosed = true;
                if (exception != null) {
                    throw exception;
                }
            }

            /*
             * Unable to fully structure code
             */
            public boolean hasNext() throws SQLException {
                if (this.isClosed) {
                    throw new SQLException("iterator is closed");
                }
                if (this.value != null) {
                    return true;
                }
                if (this.results != null || (this.results = this.initialize()) != null) ** GOTO lbl11
                return false;
lbl-1000:
                // 1 sources

                {
                    result = (IResult)this.results.next();
                    this.value = converter.convert((Object)result);
                    if (this.value == null) continue;
                    return true;
lbl11:
                    // 2 sources

                    ** while (this.results.hasNext())
                }
lbl12:
                // 1 sources

                return false;
            }

            private IResults initialize() throws SQLException {
                logger.log(ILevel.DEBUG, statementString);
                this.statement = connection.prepareStatement(statementString);
                this.statementCancler = (IWatcher)cancelWatcherFactory.create(() -> {
                    try {
                        this.statement.cancel();
                    }
                    catch (SQLException sQLException) {}
                });
                prepareProcedure.execute((Object)this.statement);
                if (this.statement.execute()) {
                    return new ResultSetToResultsAdapter(this.statement.getResultSet());
                }
                return null;
            }

            public T next() throws SQLException {
                if (this.isClosed) {
                    throw new SQLException("iterator is closed");
                }
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                try {
                    Object t = this.value;
                    return t;
                }
                finally {
                    this.value = null;
                }
            }
        };
    }

    private static String toDebugString(Object object) {
        if (object == null) {
            return null;
        }
        if (object.getClass().isArray()) {
            return object.getClass().getSimpleName();
        }
        return String.valueOf(object);
    }

    public static String getSchemaName(Connection connection, String schemaName) throws SQLException {
        return schemaName == null ? connection.getMetaData().getUserName() : schemaName;
    }

    public static void createIfNotExists(Connection connection, String schemaName, String tableName, String createStatementString) throws SQLException {
        if (DatabaseUtilities.exists(connection, schemaName, tableName)) {
            return;
        }
        DatabaseUtilities.create(connection, createStatementString);
    }

    public static boolean exists(Connection connection, String schemaName, String tableName) throws SQLException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (ResultSet tables = connection.getMetaData().getTables(connection.getCatalog(), schemaName, tableName, new String[]{"TABLE", "VIEW", "SYSTEM TABLE", "GLOBAL TEMPORARY", "LOCAL TEMPORARY", "ALIAS", "SYNONYM"});){
            return tables.next();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean execute(Statement statement, String statementString) throws SQLException {
        try {
            logger.log(ILevel.DEBUG, "Statement: " + statementString);
            if (!statement.execute(statementString)) {
                return false;
            }
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                ResultSet resultSet;
                block13: {
                    resultSet = statement.getResultSet();
                    if (resultSet.next()) break block13;
                    return false;
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (SQLException exception) {
            throw new SQLException("Executing statement '" + statementString + "' faild", exception);
        }
    }

    public static String getAsString(Statement statement, String statementString) {
        block12: {
            try {
                if (!statement.execute(statementString)) break block12;
                Throwable throwable = null;
                Object var3_5 = null;
                try (ResultSet resultSet = statement.getResultSet();){
                    if (!resultSet.next()) break block12;
                    return String.valueOf(resultSet.getObject(1));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (SQLException exception) {
                logger.log(ILevel.WARNING, exception.getMessage());
            }
        }
        return null;
    }

    public static String createSelectStatement(String tableName, Iterable<String> columnNames, Iterable<String> valueColumnNames) {
        return DatabaseUtilities.createSelectStatement(tableName, columnNames, null, valueColumnNames);
    }

    public static String createSelectStatement(String tableName, Iterable<String> columnNames, String orderByColumnName, Iterable<String> valueColumnNames) {
        boolean flag = false;
        StringBuilder builder = new StringBuilder();
        for (String columnName : valueColumnNames) {
            if (!flag) {
                builder.append("select ");
                builder.append(columnName);
                builder.append("\n");
                flag = true;
                continue;
            }
            builder.append("     , ");
            builder.append(columnName);
            builder.append("\n");
        }
        builder.append("  from ");
        builder.append(tableName);
        builder.append("\n");
        boolean clauseFlag = false;
        for (String columnName : columnNames) {
            if (!clauseFlag) {
                builder.append(" where ");
                clauseFlag = true;
            } else {
                builder.append(" and ");
            }
            builder.append(columnName);
            builder.append(" = ?");
        }
        builder.append("\n");
        if (!StringUtilities.isNullOrEmpty((String)orderByColumnName)) {
            builder.append(" order by ");
            builder.append(orderByColumnName);
            builder.append("\n");
        }
        return builder.toString();
    }

    public static String createIdentifierSelectStatement(String tableName, String identifierColumnName, Iterable<String> valueColumnNames) {
        return DatabaseUtilities.createIdentifierSelectStatement(tableName, identifierColumnName, null, valueColumnNames);
    }

    public static String createIdentifierSelectStatement(String tableName, String identifierColumnName, String orderByColumnName, Iterable<String> valueColumnNames) {
        boolean flag = false;
        StringBuilder builder = new StringBuilder();
        for (String columnName : valueColumnNames) {
            if (!flag) {
                builder.append("select ");
                builder.append(columnName);
                builder.append("\n");
                flag = true;
                continue;
            }
            builder.append("     , ");
            builder.append(columnName);
            builder.append("\n");
        }
        builder.append("  from ");
        builder.append(tableName);
        builder.append("\n");
        builder.append(" where ");
        builder.append(identifierColumnName);
        builder.append(" = ?");
        builder.append("\n");
        if (!StringUtilities.isNullOrEmpty((String)orderByColumnName)) {
            builder.append(" order by ");
            builder.append(orderByColumnName);
            builder.append("\n");
        }
        return builder.toString();
    }

    public static String[] getTableTypes(DatabaseMetaData metaData, IApplicable<String> applicableType) throws SQLException {
        ArrayList<String> types = new ArrayList<String>();
        Throwable throwable = null;
        Object var4_5 = null;
        try (ResultSet resultSet = metaData.getTableTypes();){
            while (resultSet.next()) {
                String type = resultSet.getString(1);
                if (!applicableType.isApplicable((Object)type)) continue;
                types.add(type);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return (String[])types.stream().toArray(String[]::new);
    }

    public static boolean create(Connection connection, String statementString) throws SQLException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Statement statement = connection.createStatement();){
            return statement.execute(statementString);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static String toString(ResultSet resultSet) throws SQLException {
        try {
            ResultSetMetaData metaData = resultSet.getMetaData();
            ArrayList<String> values = new ArrayList<String>();
            int i = 0;
            while (i < metaData.getColumnCount()) {
                values.add(DatabaseUtilities.toDebugString(resultSet.getObject(i + 1)));
                ++i;
            }
            return IterableUtilities.toString(values, (String)", ", s -> DatabaseUtilities.toDebugString(s));
        }
        catch (ConversionException exception) {
            throw new SQLException(exception);
        }
    }

    public static IBatchTransfer batchTransfer(Connection connection, String tableName, String[] identifierNames, String[] valueNames) {
        String selectExistsStatement = DatabaseUtilities.createSelectExistsStatement(tableName, identifierNames);
        String updateStatement = DatabaseUtilities.createUpdateStatement(tableName, identifierNames, valueNames);
        String insertStatement = DatabaseUtilities.createInsertStatement(tableName, identifierNames, valueNames);
        return DatabaseUtilities.batchTransfer(connection, selectExistsStatement, insertStatement, updateStatement);
    }

    public static IBatchTransfer batchTransfer(Connection connection, String selectExistsStatement, String insertStatement, String updateStatement) {
        int numberOfIdentifiers = DatabaseUtilities.numberOfQuestionMarks(selectExistsStatement);
        int numberOfColumns = DatabaseUtilities.numberOfQuestionMarks(insertStatement);
        return new BatchTransfer(connection, numberOfIdentifiers, numberOfColumns, selectExistsStatement, insertStatement, updateStatement);
    }

    private static String createInsertStatement(String tableName, String[] identifiers, String[] values) {
        StringBuilder builder = new StringBuilder();
        builder.append("insert into ");
        builder.append("'");
        builder.append(tableName);
        builder.append("'");
        builder.append(" (");
        boolean nameFlag = false;
        String[] stringArray = identifiers;
        int n = identifiers.length;
        int n2 = 0;
        while (n2 < n) {
            String identifier = stringArray[n2];
            if (nameFlag) {
                builder.append(", ");
            } else {
                nameFlag = true;
            }
            builder.append("'");
            builder.append(identifier);
            builder.append("'");
            ++n2;
        }
        stringArray = values;
        n = values.length;
        n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            if (nameFlag) {
                builder.append(", ");
            } else {
                nameFlag = true;
            }
            builder.append("'");
            builder.append(value);
            builder.append("'");
            ++n2;
        }
        builder.append(" )");
        builder.append(" values ");
        builder.append(" (");
        boolean valueflags = false;
        stringArray = identifiers;
        n = identifiers.length;
        n2 = 0;
        while (n2 < n) {
            if (valueflags) {
                builder.append(", ");
            } else {
                valueflags = true;
            }
            builder.append("?");
            ++n2;
        }
        stringArray = values;
        n = values.length;
        n2 = 0;
        while (n2 < n) {
            if (valueflags) {
                builder.append(", ");
            } else {
                valueflags = true;
            }
            builder.append("?");
            ++n2;
        }
        builder.append(" )");
        return builder.toString();
    }

    private static String createUpdateStatement(String tableName, String[] identifiers, String[] values) {
        StringBuilder builder = new StringBuilder();
        builder.append("update ");
        builder.append("'");
        builder.append(tableName);
        builder.append("'");
        builder.append(" set ");
        boolean valueflags = false;
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            if (valueflags) {
                builder.append(", ");
            } else {
                valueflags = true;
            }
            builder.append("'");
            builder.append(value);
            builder.append("' = ?");
            ++n2;
        }
        builder.append(" )");
        boolean clauseFlag = false;
        String[] stringArray2 = identifiers;
        int n3 = identifiers.length;
        n = 0;
        while (n < n3) {
            String identifier = stringArray2[n];
            if (clauseFlag) {
                builder.append(" and ");
            } else {
                builder.append(" where ");
                clauseFlag = true;
            }
            builder.append("'");
            builder.append(identifier);
            builder.append("' = ?");
            ++n;
        }
        return builder.toString();
    }

    private static String createSelectExistsStatement(String tableName, String[] identifiers) {
        StringBuilder builder = new StringBuilder();
        builder.append("select count(*) ");
        builder.append("'");
        builder.append(tableName);
        builder.append("'");
        boolean flag = false;
        String[] stringArray = identifiers;
        int n = identifiers.length;
        int n2 = 0;
        while (n2 < n) {
            String identifier = stringArray[n2];
            if (flag) {
                builder.append(" and ");
            } else {
                builder.append(" where ");
                flag = true;
            }
            builder.append("'");
            builder.append(identifier);
            builder.append("' = ?");
            ++n2;
        }
        return builder.toString();
    }

    private static int numberOfQuestionMarks(String string) {
        return (int)string.chars().filter(ch -> ch == 63).count();
    }

    private static /* synthetic */ void lambda$2(PreparedStatement preparedStatement) throws RuntimeException {
        try {
            preparedStatement.cancel();
        }
        catch (SQLException sQLException) {}
    }

    private static /* synthetic */ void lambda$10(PreparedStatement preparedStatement) throws RuntimeException {
        try {
            preparedStatement.cancel();
        }
        catch (SQLException sQLException) {}
    }

    private static /* synthetic */ Iterator lambda$12(final ResultSet resultSet, final List list, final IResult iResult) {
        return new Iterator<IResult>(){

            @Override
            public boolean hasNext() {
                try {
                    return resultSet.next();
                }
                catch (SQLException exception) {
                    list.add(exception);
                    return false;
                }
            }

            @Override
            public IResult next() {
                return iResult;
            }
        };
    }
}

