/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.jdbc.resource;

import java.util.Map;
import net.anwiba.commons.lang.exception.CreationException;
import net.anwiba.commons.lang.functional.ResolvingException;
import net.anwiba.commons.lang.map.HasMapBuilder;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.utilities.string.IStringAppender;
import net.anwiba.commons.utilities.string.StringAppender;
import net.anwiba.commons.utilities.string.StringResolverBuilder;

public class JdbcServiceUrlStringResolver {
    private static final String PLACEHOLDER_PROTOCOL = "protocol";
    private static final String PLACEHOLDER_DATABASE = "database";
    private static final String PLACEHOLDER_PORT = "port";
    private static final String PLACEHOLDER_HOST = "host";
    private final String urlPattern;
    private final Map<String, String> replacements;

    public JdbcServiceUrlStringResolver(String urlPattern) {
        this(urlPattern, new HasMapBuilder().build());
    }

    public JdbcServiceUrlStringResolver(String urlPattern, Map<String, String> replacements) {
        this.urlPattern = urlPattern;
        this.replacements = replacements;
    }

    public String create(String protocol, String host, String port, String database) throws CreationException {
        StringAppender errorHandler = new StringAppender();
        try {
            StringResolverBuilder builder = new StringResolverBuilder();
            Optional.of((Object)host).consume(v -> {
                StringResolverBuilder stringResolverBuilder2 = builder.add(PLACEHOLDER_HOST, v);
            });
            Optional.of((Object)port).consume(v -> {
                StringResolverBuilder stringResolverBuilder2 = builder.add(PLACEHOLDER_PORT, v);
            });
            this.replacements.forEach((k, v) -> {
                StringResolverBuilder stringResolverBuilder2 = builder.add(k, v);
            });
            String string = (String)builder.errorHandler((IStringAppender)errorHandler).optional(PLACEHOLDER_PROTOCOL, protocol).add(PLACEHOLDER_DATABASE, database).build().resolve((Object)this.urlPattern);
            return string;
        }
        catch (ResolvingException resolvingException) {
            throw new CreationException(errorHandler.toString());
        }
        finally {
            if (!errorHandler.isEmpty()) {
                throw new CreationException(errorHandler.toString());
            }
        }
    }
}

