/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.version;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Locale;
import java.util.Properties;
import net.anwiba.commons.utilities.time.ZonedDateTimeUtilities;
import net.anwiba.commons.version.IVersion;
import net.anwiba.commons.version.ProductState;
import net.anwiba.commons.version.ReleaseState;
import net.anwiba.commons.version.Version;
import net.anwiba.commons.version.VersionParser;

public class VersionUtilities {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IVersion getVersion(URL resource) {
        if (resource == null) {
            return Version.DUMMY;
        }
        Properties properties = new Properties();
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try {
                InputStream inputstream = resource.openStream();
                try {
                    Version version;
                    block17: {
                        InputStreamReader reader = new InputStreamReader(inputstream, "UTF-8");
                        try {
                            properties.load(reader);
                            int major = VersionUtilities.getIntProperty(properties, "version.mayor");
                            int minor = VersionUtilities.getIntProperty(properties, "version.minor");
                            int step = VersionUtilities.getIntProperty(properties, "version.step");
                            ReleaseState releaseState = VersionUtilities.getReleaseState(properties);
                            ProductState productState = VersionUtilities.getProductState(properties);
                            int buildCount = VersionUtilities.getIntProperty(properties, "build.count");
                            ZonedDateTime date = VersionUtilities.getDate(properties);
                            version = new Version(major, minor, releaseState, step, productState, date, buildCount);
                            return version;
                        }
                        finally {
                            if (reader == null) break block17;
                            reader.close();
                        }
                    }
                    if (inputstream != null) {
                        inputstream.close();
                    }
                    return version;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (inputstream == null) throw throwable;
                    inputstream.close();
                    throw throwable;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (IOException iOException) {
            return Version.DUMMY;
        }
    }

    private static ZonedDateTime getDate(Properties properties) {
        String property = properties.getProperty("build.date");
        if (property == null) {
            return Version.defaultDate;
        }
        try {
            return ZonedDateTimeUtilities.atCoordinatedUniversalTimeZone((LocalDateTime)LocalDateTime.parse(property, DateTimeFormatter.ofPattern("yyyy.MM.dd HH:mm", Locale.getDefault())), (ZoneId)ZonedDateTimeUtilities.getCoordinatedUniversalTimeZone());
        }
        catch (DateTimeParseException dateTimeParseException) {
            return Version.defaultDate;
        }
    }

    private static ProductState getProductState(Properties properties) {
        String property = properties.getProperty("version.state.product");
        if (property == null) {
            return ProductState.EXPERIMENTAL;
        }
        try {
            return ProductState.valueOf(property);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return ProductState.EXPERIMENTAL;
        }
    }

    private static ReleaseState getReleaseState(Properties properties) {
        String property = properties.getProperty("version.state.release");
        if (property == null) {
            return ReleaseState.RELEASE;
        }
        try {
            return ReleaseState.valueOf(property);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return ReleaseState.RELEASE;
        }
    }

    private static int getIntProperty(Properties properties, String key) {
        String property = properties.getProperty(key);
        if (property == null) {
            return 0;
        }
        return Integer.parseInt(property);
    }

    public static IVersion valueOf(String string) {
        return new VersionParser().parse(string);
    }

    public static String getText(IVersion version) {
        String string = VersionUtilities.internal(version);
        ProductState productState = version.getProductState();
        if (productState != ProductState.STABLE) {
            string = String.valueOf(string) + " ";
            string = String.valueOf(string) + String.valueOf(productState.getAcronym());
        }
        return string;
    }

    private static String internal(IVersion version) {
        String string = String.valueOf(version.getMajor());
        string = String.valueOf(string) + ".";
        string = String.valueOf(string) + String.valueOf(version.getMinor());
        ReleaseState releaseState = version.getReleaseState();
        string = releaseState != ReleaseState.RELEASE ? String.valueOf(string) + String.valueOf(releaseState.getAcronym()) : String.valueOf(string) + ".";
        string = String.valueOf(string) + String.valueOf(version.getStep());
        return string;
    }

    public static String getTextLong(IVersion version) {
        String string = VersionUtilities.internal(version);
        ProductState productState = version.getProductState();
        string = String.valueOf(string) + " ";
        string = String.valueOf(string) + String.valueOf(productState.getAcronym());
        string = String.valueOf(string) + " ";
        string = String.valueOf(string) + version.getBuildCount();
        string = String.valueOf(string) + " ";
        string = String.valueOf(string) + version.getDate().format(DateTimeFormatter.ofPattern("yyyy.MM.dd HH:mm", Locale.getDefault()));
        return string;
    }
}

