/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.crypto;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import net.anwiba.crypto.CodingException;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.DESEngine;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;

public class CryptoUtilities {
    public static String sign(String string) throws CodingException {
        try {
            return Base64.toBase64String((byte[])CryptoUtilities.sign(string.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException exception) {
            throw new CodingException(exception.getMessage(), exception);
        }
    }

    public static byte[] sign(byte[] data) throws CodingException {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            MessageDigest md = MessageDigest.getInstance("SHA-256", "BC");
            md.update(data);
            return md.digest();
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException exception) {
            throw new CodingException(exception.getMessage(), exception);
        }
    }

    public static byte[] getEncodedBytes(byte[] key, byte[] buffer) throws CodingException {
        if (key == null) {
            return buffer;
        }
        try {
            Throwable throwable = null;
            Object var3_8 = null;
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(buffer);){
                byte[] encoding = CryptoUtilities.performEncoding(new KeyParameter(key), inputStream);
                return Base64.encode((byte[])encoding);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (DataLengthException exception) {
            throw new CodingException(exception.getMessage(), exception);
        }
        catch (IllegalStateException exception) {
            throw new CodingException(exception.getMessage(), exception);
        }
        catch (InvalidCipherTextException exception) {
            throw new CodingException(exception.getMessage(), exception);
        }
        catch (IOException exception) {
            throw new CodingException(exception.getMessage(), exception);
        }
    }

    public static byte[] getDecodedBytes(byte[] key, byte[] array) throws CodingException {
        if (key == null) {
            return array;
        }
        try {
            Throwable throwable = null;
            Object var3_8 = null;
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(Base64.decode((byte[])array));){
                return CryptoUtilities.performDecoding(new KeyParameter(key), inputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (DataLengthException exception) {
            throw new CodingException(exception.getMessage(), exception);
        }
        catch (InvalidCipherTextException exception) {
            throw new CodingException(exception.getMessage(), exception);
        }
        catch (IllegalStateException exception) {
            throw new CodingException(exception.getMessage(), exception);
        }
        catch (IOException exception) {
            throw new CodingException(exception.getMessage(), exception);
        }
    }

    public static byte[] performDecoding(KeyParameter keyParameter, byte[] array) throws DataLengthException, IllegalStateException, InvalidCipherTextException, IOException {
        return CryptoUtilities.performDecoding(keyParameter, new ByteArrayInputStream(array));
    }

    public static byte[] performDecoding(KeyParameter keyParameter, InputStream inputStream) throws InvalidCipherTextException, DataLengthException, IllegalStateException, IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            CryptoUtilities.performCoding(inputStream, outputStream, CryptoUtilities.createDecodingCiper(keyParameter));
            return outputStream.toByteArray();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static byte[] performEncoding(KeyParameter keyParameter, byte[] array) throws DataLengthException, IllegalStateException, InvalidCipherTextException, IOException {
        return CryptoUtilities.performEncoding(keyParameter, new ByteArrayInputStream(array));
    }

    private static byte[] performEncoding(KeyParameter keyParameter, InputStream inputStream) throws IOException, InvalidCipherTextException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            CryptoUtilities.performCoding(inputStream, outputStream, CryptoUtilities.createEncodingChiper(keyParameter));
            return outputStream.toByteArray();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static PaddedBufferedBlockCipher createDecodingCiper(KeyParameter keyParameter) {
        return CryptoUtilities.createCipher(keyParameter, false);
    }

    private static PaddedBufferedBlockCipher createEncodingChiper(KeyParameter keyParameter) {
        return CryptoUtilities.createCipher(keyParameter, true);
    }

    private static PaddedBufferedBlockCipher createCipher(KeyParameter keyParameter, boolean forEncryption) {
        PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher((BlockCipher)new DESEngine());
        cipher.init(forEncryption, (CipherParameters)keyParameter);
        return cipher;
    }

    private static void performCoding(InputStream inputStream, OutputStream outputStream, PaddedBufferedBlockCipher cipher) throws IOException, InvalidCipherTextException {
        int outputLength;
        int length;
        byte[] input = new byte[32];
        byte[] output = new byte[cipher.getOutputSize(input.length)];
        while ((length = inputStream.read(input, 0, input.length)) > 0) {
            outputLength = cipher.processBytes(input, 0, length, output, 0);
            outputStream.write(output, 0, outputLength);
        }
        outputLength = cipher.doFinal(output, 0);
        outputStream.write(output, 0, outputLength);
    }
}

