/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.model;

import java.util.ArrayList;
import java.util.List;
import net.anwiba.commons.lang.functional.IProcedure;
import net.anwiba.commons.model.AbstractListChangedNotifier;
import net.anwiba.commons.model.IChangeableObjectListener;
import net.anwiba.commons.model.ListenerList;
import net.anwiba.commons.model.ObjectModel;

public class ObjectModelListModel<T>
extends AbstractListChangedNotifier<ObjectModel<T>> {
    private final List<ObjectModel<T>> objectModels = new ArrayList<ObjectModel<T>>();
    private final IChangeableObjectListener objectModelsListener = new IChangeableObjectListener(){

        @Override
        public void objectChanged() {
            ObjectModelListModel.this.fireValueChanged();
        }
    };
    private final ListenerList<IChangeableObjectListener> changeableObjectListeners = new ListenerList();

    public synchronized void add(ObjectModel<T> object) {
        ArrayList<ObjectModel<T>> list = new ArrayList<ObjectModel<T>>(1);
        list.add(object);
        this.addAll(list);
    }

    public synchronized void addAll(Iterable<ObjectModel<T>> objects) {
        ArrayList<ObjectModel<T>> list = new ArrayList<ObjectModel<T>>();
        for (ObjectModel<T> object : objects) {
            if (this.objectModels.contains(object)) continue;
            object.addChangeListener(this.objectModelsListener);
            list.add(object);
        }
        if (!list.isEmpty()) {
            this.objectModels.addAll(list);
            this.fireObjectsAdded(null, list);
        }
    }

    public synchronized void remove(ObjectModel<T> object) {
        ArrayList<ObjectModel<T>> list = new ArrayList<ObjectModel<T>>(1);
        list.add(object);
        this.removeAll(list);
    }

    public synchronized void removeAll(Iterable<ObjectModel<T>> objects) {
        ArrayList<ObjectModel<T>> list = new ArrayList<ObjectModel<T>>();
        for (ObjectModel<T> object : objects) {
            if (!this.objectModels.remove(object)) continue;
            object.removeChangeListener(this.objectModelsListener);
            list.add(object);
        }
        if (!list.isEmpty()) {
            this.fireObjectsRemoved(null, list);
        }
    }

    public synchronized void removeAll() {
        if (this.objectModels.isEmpty()) {
            return;
        }
        ArrayList<ObjectModel<T>> list = new ArrayList<ObjectModel<T>>(this.objectModels);
        this.objectModels.clear();
        this.fireObjectsRemoved(null, list);
    }

    public synchronized Iterable<ObjectModel<T>> models() {
        return this.objectModels;
    }

    public synchronized ObjectModel<T> last() {
        return this.objectModels.get(this.objectModels.size() - 1);
    }

    public synchronized boolean isEmpty() {
        return this.objectModels.isEmpty();
    }

    public synchronized int size() {
        return this.objectModels.size();
    }

    public final synchronized void addChangeListener(IChangeableObjectListener listener) {
        this.changeableObjectListeners.add(listener);
    }

    public final synchronized void removeChangeListener(IChangeableObjectListener listener) {
        this.changeableObjectListeners.remove(listener);
    }

    protected final synchronized void fireValueChanged() {
        this.changeableObjectListeners.forAllDo(new IProcedure<IChangeableObjectListener, RuntimeException>(){

            public void execute(IChangeableObjectListener listener) throws RuntimeException {
                listener.objectChanged();
            }
        });
    }
}

