/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.nls;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.Properties;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;

class MessagesProperties
extends Properties {
    private static ILogger logger = Logging.getLogger((String)MessagesProperties.class.getName());
    private static final int MOD_EXPECTED = 9;
    private static final int MOD_MASK = 25;
    private static final long serialVersionUID = 1L;
    private final String bundleName;
    private final Map<Object, Object> fields;
    private final boolean isAccessible;
    private final Object assignedFlag;

    MessagesProperties(Map<Object, Object> fieldMap, String bundleName, boolean isAccessible, Object assignedFlag) {
        this.fields = fieldMap;
        this.bundleName = bundleName;
        this.isAccessible = isAccessible;
        this.assignedFlag = assignedFlag;
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        Object fieldObject = this.fields.put(key, this.assignedFlag);
        if (fieldObject == this.assignedFlag) {
            return null;
        }
        if (fieldObject == null) {
            String msg = "NLS unused message: " + key + " in: " + this.bundleName;
            logger.log(ILevel.WARNING, msg);
            return null;
        }
        Field field = (Field)fieldObject;
        if ((field.getModifiers() & 0x19) != 9) {
            return null;
        }
        try {
            if (!this.isAccessible) {
                AccessController.doPrivileged(new PrivilegedFieldAccessibleSetterAction(field));
            }
            field.set(null, value);
        }
        catch (Exception e) {
            logger.log(ILevel.FATAL, "Exception setting field value.", (Throwable)e);
        }
        return null;
    }

    @Override
    public synchronized boolean equals(Object o) {
        if (o instanceof MessagesProperties) {
            MessagesProperties other = (MessagesProperties)o;
            return this.bundleName == null ? other.bundleName == null : this.bundleName == other.bundleName || this.bundleName.equals(other.bundleName) && super.equals(o);
        }
        return false;
    }

    @Override
    public synchronized int hashCode() {
        return super.hashCode();
    }

    public static final class PrivilegedFieldAccessibleSetterAction
    implements PrivilegedAction<Void> {
        private final Field field;

        public PrivilegedFieldAccessibleSetterAction(Field field) {
            this.field = field;
        }

        @Override
        public Void run() {
            this.field.setAccessible(true);
            return null;
        }
    }
}

